/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class BinaryStructure
extends Structure {
    public BinaryStructure(Term t1, String id, Term t2) {
        super(id, 2);
        this.addTerms(t1, t2);
        this.srcInfo = t1.getSrcInfo() != null ? t1.getSrcInfo() : t2.getSrcInfo();
    }

    public BinaryStructure(String id, Term arg) {
        super(id, 1);
        this.addTerm(arg);
        this.srcInfo = arg.getSrcInfo();
    }

    public boolean isUnary() {
        return this.getArity() == 1;
    }

    public Term getLHS() {
        return this.getTerm(0);
    }

    public Term getRHS() {
        return this.getTerm(1);
    }

    public String toString() {
        if (this.isUnary()) {
            return String.valueOf(this.getFunctor()) + "(" + this.getTerm(0) + ")";
        }
        return "(" + this.getTerm(0) + this.getFunctor() + this.getTerm(1) + ")";
    }

    public Element getAsDOM(Document document) {
        Element u = document.createElement("expression");
        u.setAttribute("operator", this.getFunctor().toString());
        if (this.isUnary()) {
            Element r = document.createElement("right");
            r.appendChild(this.getTerm(0).getAsDOM(document));
            u.appendChild(r);
        } else {
            Element l = document.createElement("left");
            l.appendChild(this.getTerm(0).getAsDOM(document));
            u.appendChild(l);
            Element r = document.createElement("right");
            r.appendChild(this.getTerm(1).getAsDOM(document));
            u.appendChild(r);
        }
        return u;
    }
}

