/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Agent;
import jason.asSemantics.InternalAction;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogExpr;
import jason.asSyntax.Pred;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.VarTerm;
import jason.stdlib.foreach;
import jason.stdlib.loop;
import jason.stdlib.wait;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalActionLiteral
extends LiteralImpl {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(InternalActionLiteral.class.getName());
    private InternalAction ia = null;

    public InternalActionLiteral(String functor) {
        super(functor);
    }

    public InternalActionLiteral(InternalActionLiteral l) {
        super(l);
        this.ia = l.ia;
        this.predicateIndicatorCache = l.predicateIndicatorCache;
        this.hashCodeCache = l.hashCodeCache;
    }

    public InternalActionLiteral(Pred p, Agent ag) throws Exception {
        super(p);
        if (ag != null) {
            this.ia = ag.getIA(this.getFunctor());
        }
    }

    @Override
    public boolean isInternalAction() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean canBeAddedInBB() {
        return false;
    }

    @Override
    public boolean apply(Unifier u) {
        if (this.ia != null && (this.ia instanceof loop || this.ia instanceof foreach)) {
            return false;
        }
        return super.apply(u);
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        super.countVars(c);
        if (this.ia != null && this.ia instanceof wait && this.getTerm(0).isString()) {
            try {
                Trigger te = ASSyntax.parseTrigger(((StringTerm)this.getTerm(0)).getString());
                te.getLiteral().countVars(c);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        if (ag.getTS().getUserAgArch().isRunning()) {
            try {
                Term[] clone = this.getTermsArray();
                int i = 0;
                while (i < clone.length) {
                    clone[i] = clone[i].clone();
                    clone[i].apply(un);
                    ++i;
                }
                Object oresult = this.getIA(ag).execute(ag.getTS(), un, clone);
                if (oresult instanceof Boolean && ((Boolean)oresult).booleanValue()) {
                    return LogExpr.createUnifIterator(un);
                }
                if (oresult instanceof Iterator) {
                    return (Iterator)oresult;
                }
            }
            catch (Exception e2) {
                logger.log(Level.SEVERE, String.valueOf(this.getErrorMsg()) + ": " + e2.getMessage(), e2);
            }
        }
        return LogExpr.EMPTY_UNIF_LIST.iterator();
    }

    public InternalAction getIA(Agent ag) throws Exception {
        if (this.ia == null && ag != null) {
            this.ia = ag.getIA(this.getFunctor());
        }
        return this.ia;
    }

    @Override
    public String getErrorMsg() {
        String src = this.getSrcInfo() == null ? "" : " (" + this.getSrcInfo() + ")";
        return "Error in internal action '" + this + "'" + src;
    }

    @Override
    public InternalActionLiteral clone() {
        return new InternalActionLiteral(this);
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = super.getAsDOM(document);
        u.setAttribute("ia", String.valueOf(this.isInternalAction()));
        return u;
    }
}

