/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTermImpl
extends Structure
implements ListTerm {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(ListTermImpl.class.getName());
    public static final String LIST_FUNCTOR = ".";
    private Term term;
    private Term next;

    public ListTermImpl() {
        super(LIST_FUNCTOR, 0);
    }

    private ListTermImpl(Term t, Term n) {
        super(LIST_FUNCTOR, 0);
        this.term = t;
        this.next = n;
    }

    public static ListTerm parseList(String sList) {
        as2j parser = new as2j(new StringReader(sList));
        try {
            return parser.list();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing list " + sList, e2);
            return null;
        }
    }

    @Override
    public ListTerm clone() {
        ListTermImpl t = new ListTermImpl();
        if (this.term != null) {
            t.term = this.term.clone();
        }
        if (this.next != null) {
            t.next = this.next.clone();
        }
        return t;
    }

    @Override
    public ListTerm cloneLT() {
        return this.clone();
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (t instanceof Term && ((Term)t).isVar()) {
            return false;
        }
        if (t instanceof ListTerm) {
            ListTerm tAsList = (ListTerm)t;
            if (this.term == null && tAsList.getTerm() != null) {
                return false;
            }
            if (this.term != null && !this.term.equals(tAsList.getTerm())) {
                return false;
            }
            if (this.next == null && tAsList.getNext() != null) {
                return false;
            }
            if (this.next != null) {
                return this.next.equals(tAsList.getNext());
            }
            return true;
        }
        return false;
    }

    @Override
    public int calcHashCode() {
        int code = 37;
        if (this.term != null) {
            code += this.term.hashCode();
        }
        if (this.next != null) {
            code += this.next.hashCode();
        }
        return code;
    }

    @Override
    public void setTerm(Term t) {
        this.term = t;
    }

    @Override
    public Term getTerm() {
        return this.term;
    }

    @Override
    public void setNext(Term l) {
        this.next = l;
    }

    @Override
    public ListTerm getNext() {
        if (this.next instanceof ListTerm) {
            return (ListTerm)this.next;
        }
        return null;
    }

    @Override
    public int getArity() {
        if (this.isEmpty()) {
            return 0;
        }
        return 2;
    }

    @Override
    public Term getTerm(int i) {
        if (i == 0) {
            return this.term;
        }
        if (i == 1) {
            return this.next;
        }
        return null;
    }

    @Override
    public void setTerm(int i, Term t) {
        if (i == 0) {
            this.term = t;
        }
        if (i == 1) {
            this.next = t;
        }
    }

    @Override
    public List<Term> getTerms() {
        logger.warning("Do not use getTerms in lists!");
        ArrayList<Term> l = new ArrayList<Term>(2);
        if (this.term != null) {
            l.add(this.term);
        }
        if (this.next != null) {
            l.add(this.next);
        }
        return l;
    }

    @Override
    public void addTerm(Term t) {
        logger.warning("Do not use addTerm in lists! Use add(Term).");
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.isTail()) {
            return 1;
        }
        return this.getNext().size() + 1;
    }

    @Override
    public boolean isAtom() {
        return false;
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.term == null;
    }

    @Override
    public boolean isEnd() {
        return this.isEmpty() || this.isTail();
    }

    @Override
    public boolean isGround() {
        if (this.isEmpty()) {
            return true;
        }
        if (this.isTail()) {
            return false;
        }
        if (this.term != null && this.term.isGround()) {
            return this.getNext().isGround();
        }
        return false;
    }

    @Override
    public boolean apply(Unifier u) {
        if (this.isEmpty()) {
            return false;
        }
        if (this.term != null) {
            boolean rn = this.term.apply(u);
            boolean rt = this.getNext().apply(u);
            return rn || rt;
        }
        return false;
    }

    @Override
    public boolean isTail() {
        return this.next != null && this.next.isVar();
    }

    @Override
    public VarTerm getTail() {
        if (this.isTail()) {
            return (VarTerm)this.next;
        }
        if (this.next != null) {
            return this.getNext().getTail();
        }
        return null;
    }

    @Override
    public void setTail(VarTerm v) {
        if (this.getNext().isEmpty()) {
            this.next = v;
        } else {
            this.getNext().setTail(v);
        }
    }

    @Override
    public ListTerm getLast() {
        if (this.isEnd()) {
            return this;
        }
        if (this.next != null) {
            return this.getNext().getLast();
        }
        return null;
    }

    @Override
    public ListTerm append(Term t) {
        if (this.isEmpty()) {
            this.term = t;
            this.next = new ListTermImpl();
            return this;
        }
        if (this.isTail()) {
            return null;
        }
        return this.getNext().append(t);
    }

    @Override
    public ListTerm concat(ListTerm lt) {
        if (this.isEmpty()) {
            this.setValuesFrom(lt);
        } else if (((ListTerm)this.next).isEmpty()) {
            this.next = lt;
        } else {
            ((ListTerm)this.next).concat(lt);
        }
        return lt.getLast();
    }

    @Override
    public ListTerm reverse() {
        return this.reverse_internal(new ListTermImpl());
    }

    private ListTerm reverse_internal(ListTerm r) {
        if (this.isEmpty()) {
            return r;
        }
        if (this.isTail()) {
            r = new ListTermImpl(this.term.clone(), r);
            r.setTail((VarTerm)this.next.clone());
            return r;
        }
        return ((ListTermImpl)this.next).reverse_internal(new ListTermImpl(this.term.clone(), r));
    }

    @Override
    public ListTerm union(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(lt);
        set.addAll(this);
        return this.setToList(set);
    }

    @Override
    public ListTerm intersection(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(lt);
        set.retainAll(this);
        return this.setToList(set);
    }

    @Override
    public ListTerm difference(ListTerm lt) {
        TreeSet<Term> set = new TreeSet<Term>();
        set.addAll(this);
        set.removeAll(lt);
        return this.setToList(set);
    }

    private ListTerm setToList(Set<Term> set) {
        ListTermImpl result;
        ListTerm tail = result = new ListTermImpl();
        for (Term t : set) {
            tail = tail.append(t.clone());
        }
        return result;
    }

    @Override
    public Iterator<ListTerm> listTermIterator() {
        ListTermImpl lt = this;
        return new Iterator<ListTerm>(lt){
            ListTerm nextLT;
            ListTerm current;
            {
                this.nextLT = listTermImpl2;
                this.current = null;
            }

            @Override
            public boolean hasNext() {
                return this.nextLT != null && !this.nextLT.isEmpty() && this.nextLT.isList();
            }

            @Override
            public ListTerm next() {
                this.current = this.nextLT;
                this.nextLT = this.nextLT.getNext();
                return this.current;
            }

            @Override
            public void remove() {
                if (this.current != null && this.nextLT != null) {
                    this.current.setTerm(this.nextLT.getTerm());
                    this.current.setNext(this.nextLT.getNext());
                    this.nextLT = this.current;
                }
            }
        };
    }

    @Override
    public Iterator<Term> iterator() {
        final Iterator<ListTerm> i = this.listTermIterator();
        return new Iterator<Term>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public Term next() {
                return ((ListTerm)i.next()).getTerm();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public List<Term> getAsList() {
        ArrayList<Term> l = new ArrayList<Term>();
        for (Term t : this) {
            l.add(t);
        }
        return l;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder("[");
        Iterator<ListTerm> i = this.listTermIterator();
        while (i.hasNext()) {
            ListTerm lt = i.next();
            s.append(lt.getTerm());
            if (lt.isTail()) {
                s.append('|');
                s.append(lt.getNext());
                continue;
            }
            if (!i.hasNext()) continue;
            s.append(',');
        }
        s.append(']');
        return s.toString();
    }

    @Override
    public void add(int index, Term o) {
        if (index == 0) {
            ListTermImpl n = new ListTermImpl(this.term, this.next);
            this.term = o;
            this.next = n;
        } else if (index > 0 && this.getNext() != null) {
            this.getNext().add(index - 1, o);
        }
    }

    @Override
    public boolean add(Term o) {
        return this.append(o) != null;
    }

    @Override
    public boolean addAll(Collection c) {
        if (c == null) {
            return false;
        }
        ListTerm lt = this;
        Iterator i = c.iterator();
        while (i.hasNext()) {
            lt = lt.append((Term)i.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection c) {
        Iterator i = c.iterator();
        int p = index;
        while (i.hasNext()) {
            this.add(p, (Term)i.next());
            ++p;
        }
        return true;
    }

    @Override
    public void clear() {
        this.term = null;
        this.next = null;
    }

    @Override
    public boolean contains(Object o) {
        if (this.term != null && this.term.equals(o)) {
            return true;
        }
        if (this.getNext() != null) {
            return this.getNext().contains(o);
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection c) {
        boolean r = true;
        Iterator i = c.iterator();
        while (i.hasNext() && r) {
            boolean bl = r = r && this.contains(i.next());
        }
        return r;
    }

    @Override
    public Term get(int index) {
        if (index == 0) {
            return this.term;
        }
        if (this.getNext() != null) {
            return (Term)this.getNext().get(index - 1);
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        int n;
        if (this.term.equals(o)) {
            return 0;
        }
        if (this.getNext() != null && (n = this.getNext().indexOf(o)) >= 0) {
            return n + 1;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object arg0) {
        return this.getAsList().lastIndexOf(arg0);
    }

    @Override
    public ListIterator<Term> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<Term> listIterator(final int startIndex) {
        final ListTermImpl list2 = this;
        return new ListIterator<Term>(){
            int pos;
            int last;
            int size;
            {
                this.pos = n;
                this.last = -1;
                this.size = ListTermImpl.this.size();
            }

            @Override
            public void add(Term o) {
                list2.add(this.last, o);
            }

            @Override
            public boolean hasNext() {
                return this.pos < this.size;
            }

            @Override
            public boolean hasPrevious() {
                return this.pos > startIndex;
            }

            @Override
            public Term next() {
                this.last = this.pos++;
                return ListTermImpl.this.get(this.last);
            }

            @Override
            public int nextIndex() {
                return this.pos + 1;
            }

            @Override
            public Term previous() {
                this.last = this.pos--;
                return ListTermImpl.this.get(this.last);
            }

            @Override
            public int previousIndex() {
                return this.pos - 1;
            }

            @Override
            public void remove() {
                list2.remove(this.last);
            }

            @Override
            public void set(Term o) {
                this.remove();
                this.add(o);
            }
        };
    }

    protected void setValuesFrom(ListTerm lt) {
        this.term = lt.getTerm();
        this.next = lt.getNext();
    }

    @Override
    public Term remove(int index) {
        if (index == 0) {
            Term bt = this.term;
            if (this.getNext() != null) {
                this.setValuesFrom(this.getNext());
            } else {
                this.clear();
            }
            return bt;
        }
        if (this.getNext() != null) {
            return (Term)this.getNext().remove(index - 1);
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (this.term != null && this.term.equals(o)) {
            if (this.getNext() != null) {
                this.setValuesFrom(this.getNext());
            } else {
                this.clear();
            }
            return true;
        }
        if (this.getNext() != null) {
            return this.getNext().remove(o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean r = true;
        Iterator i = c.iterator();
        while (i.hasNext() && r) {
            boolean bl = r = r && this.remove(i.next());
        }
        return r;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean r = true;
        for (Term t : this) {
            if (c.contains(t)) continue;
            boolean bl = r = r && this.remove(t);
        }
        return r;
    }

    @Override
    public Term set(int index, Term t) {
        if (index == 0) {
            this.term = t;
            return t;
        }
        if (this.getNext() != null) {
            return this.getNext().set(index - 1, t);
        }
        return null;
    }

    @Override
    public List<Term> subList(int arg0, int arg1) {
        return this.getAsList().subList(arg0, arg1);
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[0]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int s = this.size();
        if (a.length < s) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), s);
        }
        int i = 0;
        for (Term t : this) {
            a[i++] = t;
        }
        if (a.length > s) {
            a[s] = null;
        }
        return a;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("list-term");
        String c = "";
        for (Term t : this) {
            Element et = t.getAsDOM(document);
            et.setAttribute("sep", c);
            c = ",";
            u.appendChild(et);
        }
        VarTerm tail = this.getTail();
        if (tail != null) {
            Element et = tail.getAsDOM(document);
            et.setAttribute("sep", "|");
            u.appendChild(et);
        }
        return u;
    }
}

