/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanBodyImpl;
import jason.asSyntax.Pred;
import jason.asSyntax.SourceInfo;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plan
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Term TAtomic = ASSyntax.createAtom("atomic");
    private static final Term TBreakPoint = ASSyntax.createAtom("breakpoint");
    private static final Term TAllUnifs = ASSyntax.createAtom("all_unifs");
    private static Logger logger = Logger.getLogger(Plan.class.getName());
    private Pred label = null;
    private Trigger tevent = null;
    private LogicalFormula context;
    private PlanBody body;
    protected SourceInfo srcInfo = null;
    private boolean isAtomic = false;
    private boolean isAllUnifs = false;
    private boolean hasBreakpoint = false;

    public Plan() {
    }

    public Plan(Pred label, Trigger te, LogicalFormula ct, PlanBody bd) {
        this.tevent = te;
        this.setLabel(label);
        this.setContext(ct);
        this.body = bd == null ? new PlanBodyImpl() : bd;
    }

    public void setLabel(Pred p) {
        this.label = p;
        if (p != null && p.hasAnnot()) {
            for (Term t : this.label.getAnnots()) {
                if (t.equals(TAtomic)) {
                    this.isAtomic = true;
                }
                if (t.equals(TBreakPoint)) {
                    this.hasBreakpoint = true;
                }
                if (!t.equals(TAllUnifs)) continue;
                this.isAllUnifs = true;
            }
        }
    }

    public Pred getLabel() {
        return this.label;
    }

    public void setContext(LogicalFormula le) {
        this.context = le;
        if (Literal.LTrue.equals(le)) {
            this.context = null;
        }
    }

    public static Plan parse(String sPlan) {
        as2j parser = new as2j(new StringReader(sPlan));
        try {
            return parser.plan();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing plan " + sPlan, e2);
            return null;
        }
    }

    public Trigger getTriggerEvent() {
        return this.tevent;
    }

    public Trigger getTrigger() {
        return this.tevent;
    }

    public LogicalFormula getContext() {
        return this.context;
    }

    public PlanBody getBody() {
        return this.body;
    }

    public boolean isAtomic() {
        return this.isAtomic;
    }

    public boolean hasBreakpoint() {
        return this.hasBreakpoint;
    }

    public boolean isAllUnifs() {
        return this.isAllUnifs;
    }

    public Unifier isRelevant(Trigger te) {
        Unifier u = new Unifier();
        if (u.unifiesNoUndo(this.tevent, te)) {
            return u;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof Plan) {
            Plan p = (Plan)o;
            if (this.context == null && p.context != null) {
                return false;
            }
            if (this.context != null && p.context != null && !this.context.equals(p.context)) {
                return false;
            }
            return this.tevent.equals(p.tevent) && this.body.equals(p.body);
        }
        return false;
    }

    public List<VarTerm> getSingletonVars() {
        HashMap<VarTerm, Integer> all = new HashMap<VarTerm, Integer>();
        this.tevent.getLiteral().countVars(all);
        if (this.context != null) {
            this.context.countVars(all);
        }
        this.body.countVars(all);
        ArrayList<VarTerm> r = new ArrayList<VarTerm>();
        for (VarTerm k : all.keySet()) {
            if ((Integer)all.get(k) != 1 || k.isUnnamedVar()) continue;
            r.add(k);
        }
        return r;
    }

    public int hashCode() {
        int code = 37;
        if (this.context != null) {
            code += this.context.hashCode();
        }
        if (this.tevent != null) {
            code += this.tevent.hashCode();
        }
        return code += this.body.hashCode();
    }

    public Object clone() {
        Plan p = new Plan();
        if (this.label != null) {
            p.label = (Pred)this.label.clone();
            p.isAtomic = this.isAtomic;
            p.hasBreakpoint = this.hasBreakpoint;
            p.isAllUnifs = this.isAllUnifs;
        }
        p.tevent = this.tevent.clone();
        if (this.context != null) {
            p.context = (LogicalFormula)this.context.clone();
        }
        p.body = (PlanBody)this.body.clone();
        p.setSrcInfo(this.srcInfo);
        return p;
    }

    public Plan cloneOnlyBody() {
        Plan p = new Plan();
        if (this.label != null) {
            p.label = this.label;
            p.isAtomic = this.isAtomic;
            p.hasBreakpoint = this.hasBreakpoint;
            p.isAllUnifs = this.isAllUnifs;
        }
        p.tevent = this.tevent.clone();
        p.context = this.context;
        p.body = this.body.clonePB();
        p.setSrcInfo(this.srcInfo);
        return p;
    }

    public SourceInfo getSrcInfo() {
        return this.srcInfo;
    }

    public void setSrcInfo(SourceInfo s) {
        this.srcInfo = s;
    }

    public String toString() {
        return this.toASString();
    }

    public String toASString() {
        return String.valueOf(this.label == null ? "" : "@" + this.label + " ") + this.tevent + (this.context == null ? "" : " : " + this.context) + (this.body.isEmptyBody() ? "" : " <- " + this.body) + ".";
    }

    public Element getAsDOM(Document document) {
        Element u = document.createElement("plan");
        if (this.label != null) {
            Element l = document.createElement("label");
            l.appendChild(new LiteralImpl(this.label).getAsDOM(document));
            u.appendChild(l);
        }
        u.appendChild(this.tevent.getAsDOM(document));
        if (this.context != null) {
            Element ec = document.createElement("context");
            ec.appendChild(this.context.getAsDOM(document));
            u.appendChild(ec);
        }
        if (!this.body.isEmptyBody()) {
            u.appendChild(this.body.getAsDOM(document));
        }
        return u;
    }
}

