/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.PlanBody;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import java.util.Iterator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanBodyImpl
extends Structure
implements PlanBody,
Iterable<PlanBody> {
    private static final long serialVersionUID = 1L;
    public static final String BODY_PLAN_FUNCTOR = ";";
    private Term term = null;
    private PlanBody next = null;
    private PlanBody.BodyType formType = PlanBody.BodyType.none;
    private boolean isTerm = false;

    public PlanBodyImpl() {
        super(BODY_PLAN_FUNCTOR, 0);
    }

    public PlanBodyImpl(PlanBody.BodyType t, Term b) {
        super(BODY_PLAN_FUNCTOR, 0);
        this.term = b;
        this.formType = t;
        if (b != null) {
            this.srcInfo = b.getSrcInfo();
        }
    }

    @Override
    public void setBodyNext(PlanBody next) {
        this.next = next;
    }

    @Override
    public PlanBody getBodyNext() {
        return this.next;
    }

    @Override
    public boolean isEmptyBody() {
        return this.term == null;
    }

    @Override
    public PlanBody.BodyType getBodyType() {
        return this.formType;
    }

    @Override
    public void setBodyType(PlanBody.BodyType bt) {
        this.formType = bt;
    }

    @Override
    public Term getBodyTerm() {
        return this.term;
    }

    @Override
    public void setBodyTerm(Term t) {
        this.term = t;
    }

    @Override
    public boolean isBodyTerm() {
        return this.isTerm;
    }

    @Override
    public void setAsBodyTerm(boolean b) {
        this.isTerm = b;
    }

    @Override
    public boolean isPlanBody() {
        return true;
    }

    @Override
    public Iterator<PlanBody> iterator() {
        return new Iterator<PlanBody>(){
            PlanBody current;
            {
                this.current = PlanBodyImpl.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null && this.current.getBodyTerm() != null;
            }

            @Override
            public PlanBody next() {
                PlanBody r = this.current;
                if (this.current != null) {
                    this.current = this.current.getBodyNext();
                }
                return r;
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public int getArity() {
        if (this.term == null) {
            return 0;
        }
        if (this.next == null) {
            return 1;
        }
        return 2;
    }

    @Override
    public Term getTerm(int i) {
        if (i == 0) {
            return this.term;
        }
        if (i == 1) {
            if (this.next != null && this.next.getBodyTerm().isVar() && this.next.getBodyNext() == null) {
                return this.next.getBodyTerm();
            }
            return this.next;
        }
        return null;
    }

    @Override
    public void setTerm(int i, Term t) {
        if (i == 0) {
            this.term = t;
        }
        if (i == 1) {
            System.out.println("Should not set next of body literal!");
        }
    }

    @Override
    public boolean apply(Unifier u) {
        this.resetHashCodeCache();
        if (this.term != null && this.term.apply(u)) {
            if (this.term.isPlanBody()) {
                this.formType = ((PlanBody)this.term).getBodyType();
                this.term = ((PlanBody)this.term).getBodyTerm();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof PlanBody) {
            PlanBody b = (PlanBody)o;
            return this.formType == b.getBodyType() && super.equals(o);
        }
        return false;
    }

    @Override
    public int calcHashCode() {
        return this.formType.hashCode() + super.calcHashCode();
    }

    @Override
    public boolean add(PlanBody bl) {
        if (this.term == null) {
            bl = bl.clonePB();
            this.swap(bl);
            this.next = bl.getBodyNext();
        } else if (this.next == null) {
            this.next = bl;
        } else {
            this.next.add(bl);
        }
        return true;
    }

    @Override
    public PlanBody getLastBody() {
        if (this.next == null) {
            return this;
        }
        return this.next.getLastBody();
    }

    @Override
    public boolean add(int index, PlanBody bl) {
        if (index == 0) {
            PlanBodyImpl newpb = new PlanBodyImpl(this.formType, this.term);
            newpb.setBodyNext(this.next);
            this.swap(bl);
            this.next = bl.getBodyNext();
            this.getLastBody().setBodyNext(newpb);
        } else if (this.next != null) {
            this.next.add(index - 1, bl);
        } else {
            this.next = bl;
        }
        return true;
    }

    @Override
    public Term removeBody(int index) {
        if (index == 0) {
            Term oldvalue = this.term;
            if (this.next == null) {
                this.term = null;
            } else {
                this.swap(this.next);
                this.next = this.next.getBodyNext();
            }
            return oldvalue;
        }
        return this.next.removeBody(index - 1);
    }

    @Override
    public int getPlanSize() {
        if (this.term == null) {
            return 0;
        }
        if (this.next == null) {
            return 1;
        }
        return this.next.getPlanSize() + 1;
    }

    private void swap(PlanBody bl) {
        PlanBody.BodyType bt = this.formType;
        this.formType = bl.getBodyType();
        bl.setBodyType(bt);
        Term l = this.term;
        this.term = bl.getBodyTerm();
        bl.setBodyTerm(l);
    }

    @Override
    public PlanBody clone() {
        if (this.term == null) {
            return new PlanBodyImpl();
        }
        PlanBodyImpl c = new PlanBodyImpl(this.formType, this.term.clone());
        c.isTerm = this.isTerm;
        if (this.next != null) {
            c.setBodyNext(this.getBodyNext().clonePB());
        }
        return c;
    }

    @Override
    public PlanBody clonePB() {
        return this.clone();
    }

    @Override
    public String toString() {
        String e2;
        String b;
        if (this.term == null) {
            return "";
        }
        if (this.isTerm) {
            b = "{ ";
            e2 = " }";
        } else {
            b = "";
            e2 = "";
        }
        if (this.next == null) {
            return String.valueOf(b) + this.formType.toString() + this.term + e2;
        }
        return String.valueOf(b) + this.formType.toString() + this.term + "; " + this.next + e2;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element eb = document.createElement("body");
        PlanBody bl = this;
        while (bl != null && !bl.isEmptyBody()) {
            Element u = document.createElement("body-literal");
            if (bl.getBodyType().toString().length() > 0) {
                u.setAttribute("type", bl.getBodyType().toString());
            }
            u.appendChild(((Structure)bl.getBodyTerm()).getAsDOM(document));
            eb.appendChild(u);
            bl = bl.getBodyNext();
        }
        return eb;
    }
}

