/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.JasonException;
import jason.asSyntax.Atom;
import jason.asSyntax.Plan;
import jason.asSyntax.Pred;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import jason.bb.BeliefBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlanLibrary
implements Iterable<Plan> {
    private Map<PredicateIndicator, List<Plan>> relPlans = new HashMap<PredicateIndicator, List<Plan>>();
    private List<Plan> plans = new ArrayList<Plan>();
    private List<Plan> varPlans = new ArrayList<Plan>();
    private Map<String, Plan> planLabels = new HashMap<String, Plan>();
    private static int lastPlanLabel = 0;
    private Logger logger = Logger.getLogger(PlanLibrary.class.getName());
    public static final Trigger TE_IDLE = new Trigger(Trigger.TEOperator.add, Trigger.TEType.achieve, new Atom("idle"));

    public Plan add(StringTerm stPlan, Term tSource) {
        return this.add(stPlan, tSource, false);
    }

    public Plan add(StringTerm stPlan, Term tSource, boolean before) {
        String sPlan = stPlan.getString();
        try {
            StringBuilder sTemp = new StringBuilder();
            int c = 0;
            while (c < sPlan.length()) {
                if (sPlan.charAt(c) != '\\') {
                    sTemp.append(sPlan.charAt(c));
                }
                ++c;
            }
            sPlan = sTemp.toString();
            Plan p = Plan.parse(sPlan);
            if (p != null) {
                int i = this.plans.indexOf(p);
                if (i < 0) {
                    if (p.getLabel() == null) {
                        p.setLabel(this.getUniqueLabel());
                    }
                    p.getLabel().addSource(tSource);
                    this.add(p, before);
                } else {
                    p = this.plans.get(i);
                    p.getLabel().addSource(tSource);
                }
                return p;
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error adding plan " + stPlan, e2);
        }
        return null;
    }

    public void add(Plan p) throws JasonException {
        this.add(p, false);
    }

    public void add(Plan p, boolean before) throws JasonException {
        if (p.getLabel() != null && this.planLabels.keySet().contains(p.getLabel().getFunctor())) {
            Plan planInPL = this.get(p.getLabel().getFunctor());
            if (p.equals(planInPL)) {
                planInPL.getLabel().addSource((Pred)p.getLabel().getSources().get(0));
                return;
            }
            throw new JasonException("There already is a plan with label " + p.getLabel());
        }
        if (p.getLabel() == null) {
            p.setLabel(this.getUniqueLabel());
        }
        if (!p.getLabel().hasSource()) {
            p.getLabel().addAnnot(BeliefBase.TSelf);
        }
        this.planLabels.put(p.getLabel().getFunctor(), p);
        Trigger pte = p.getTrigger();
        if (pte.getLiteral().isVar()) {
            if (before) {
                this.varPlans.add(0, p);
            } else {
                this.varPlans.add(p);
            }
            for (List<Plan> lp : this.relPlans.values()) {
                if (lp.isEmpty() || !lp.get(0).getTrigger().sameType(pte)) continue;
                if (before) {
                    lp.add(0, p);
                    continue;
                }
                lp.add(p);
            }
        } else {
            List<Plan> codesList = this.relPlans.get(pte.getPredicateIndicator());
            if (codesList == null) {
                codesList = new ArrayList<Plan>();
                for (Plan vp : this.varPlans) {
                    if (!vp.getTrigger().sameType(pte)) continue;
                    codesList.add(vp);
                }
                this.relPlans.put(pte.getPredicateIndicator(), codesList);
            }
            if (before) {
                codesList.add(0, p);
            } else {
                codesList.add(p);
            }
        }
        if (before) {
            this.plans.add(0, p);
        } else {
            this.plans.add(p);
        }
    }

    public void addAll(PlanLibrary pl) throws JasonException {
        for (Plan p : pl) {
            this.add(p, false);
        }
    }

    public void addAll(List<Plan> plans) throws JasonException {
        for (Plan p : plans) {
            this.add(p, false);
        }
    }

    private Pred getUniqueLabel() {
        String l;
        do {
            l = "l__" + lastPlanLabel++;
        } while (this.planLabels.keySet().contains(l));
        return new Pred(l);
    }

    public Plan get(String label) {
        return this.planLabels.get(label);
    }

    public int size() {
        return this.plans.size();
    }

    public List<Plan> getPlans() {
        return this.plans;
    }

    @Override
    public Iterator<Plan> iterator() {
        return this.plans.iterator();
    }

    public void clear() {
        this.planLabels.clear();
        this.plans.clear();
        this.varPlans.clear();
        this.relPlans.clear();
    }

    public boolean remove(Atom pLabel, Term source) {
        Plan p = this.get(pLabel.getFunctor());
        if (p != null) {
            boolean hasSource = p.getLabel().delSource(source);
            if (hasSource && !p.getLabel().hasSource()) {
                this.remove(pLabel.getFunctor());
            }
            return true;
        }
        return false;
    }

    public Plan remove(String pLabel) {
        Plan p = this.planLabels.remove(pLabel);
        this.plans.remove(p);
        if (p.getTrigger().getLiteral().isVar()) {
            this.varPlans.remove(p);
            for (List<Plan> lp : this.relPlans.values()) {
                lp.remove(p);
            }
        } else {
            List<Plan> codesList = this.relPlans.get(p.getTrigger().getPredicateIndicator());
            codesList.remove(p);
            if (codesList.isEmpty()) {
                this.relPlans.remove(p.getTrigger().getPredicateIndicator());
            }
        }
        return p;
    }

    public boolean isRelevant(Trigger te) {
        return this.hasCandidatePlan(te);
    }

    public boolean hasCandidatePlan(Trigger te) {
        List<Plan> l = this.getCandidatePlans(te);
        return l != null && !l.isEmpty();
    }

    public List<Plan> getAllRelevant(Trigger te) {
        return this.getCandidatePlans(te);
    }

    public List<Plan> getCandidatePlans(Trigger te) {
        List<Plan> l = this.relPlans.get(te.getPredicateIndicator());
        if ((l == null || l.isEmpty()) && !this.varPlans.isEmpty()) {
            l = new ArrayList<Plan>();
            for (Plan p : this.varPlans) {
                if (!p.getTrigger().sameType(te)) continue;
                l.add(p);
            }
        }
        return l;
    }

    public List<Plan> getIdlePlans() {
        return this.relPlans.get(TE_IDLE.getPredicateIndicator());
    }

    public Object clone() {
        PlanLibrary pl = new PlanLibrary();
        try {
            pl.addAll(this);
        }
        catch (JasonException e2) {
            e2.printStackTrace();
        }
        return pl;
    }

    public String toString() {
        return this.plans.toString();
    }

    public Element getAsDOM(Document document) {
        Element eplans = document.createElement("plans");
        String lastFunctor = null;
        for (Plan p : this.plans) {
            String currentFunctor = p.getTrigger().getLiteral().getFunctor();
            if (lastFunctor != null && !currentFunctor.equals(lastFunctor)) {
                eplans.appendChild(document.createElement("new-set-of-plans"));
            }
            lastFunctor = currentFunctor;
            eplans.appendChild(p.getAsDOM(document));
        }
        return eplans;
    }
}

