/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.UnnamedVar;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pred
extends Structure {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Pred.class.getName());
    private ListTerm annots;

    public Pred(String functor) {
        super(functor);
    }

    public Pred(Literal l) {
        super(l);
        this.annots = l.hasAnnot() ? l.getAnnots().cloneLT() : null;
    }

    public Pred(String functor, int termsSize) {
        super(functor, termsSize);
    }

    public static Pred parsePred(String sPred) {
        as2j parser = new as2j(new StringReader(sPred));
        try {
            return parser.pred();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing predicate " + sPred, e2);
            return null;
        }
    }

    @Override
    public boolean isPred() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return super.isAtom() && !this.hasAnnot();
    }

    @Override
    public boolean isGround() {
        if (this.annots == null) {
            return super.isGround();
        }
        return super.isGround() && this.annots.isGround();
    }

    @Override
    public boolean apply(Unifier u) {
        boolean r = super.apply(u);
        if (this.annots != null) {
            boolean ra = this.annots.apply(u);
            r = r || ra;
        }
        return r;
    }

    @Override
    public void setAnnots(ListTerm l) {
        this.annots = l;
        if (this.annots != null && this.annots.isEmpty()) {
            this.annots = null;
        }
    }

    @Override
    public boolean addAnnot(Term t) {
        if (this.annots == null) {
            this.annots = new ListTermImpl();
        }
        if (!this.annots.contains(t)) {
            this.annots.add(t);
            return true;
        }
        return false;
    }

    @Override
    public Literal addAnnots(List<Term> l) {
        if (l == null || l.isEmpty()) {
            return this;
        }
        ListTerm tail = this.annots == null ? (this.annots = new ListTermImpl()) : this.annots.getLast();
        for (Term t : l) {
            if (this.annots.contains(t)) continue;
            tail = tail.append(t);
        }
        return this;
    }

    @Override
    public Literal addAnnots(Term ... l) {
        ListTerm tail = this.annots == null ? (this.annots = new ListTermImpl()) : this.annots.getLast();
        Term[] termArray = l;
        int n = l.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            if (!this.annots.contains(t)) {
                tail = tail.append(t);
            }
            ++n2;
        }
        return this;
    }

    @Override
    public void delAnnot(Term t) {
        if (this.annots != null) {
            this.annots.remove(t);
        }
    }

    @Override
    public void clearAnnots() {
        this.annots = null;
    }

    @Override
    public ListTerm getAnnots() {
        return this.annots;
    }

    @Override
    public boolean hasAnnot(Term t) {
        if (this.annots == null) {
            return false;
        }
        return this.annots.contains(t);
    }

    @Override
    public boolean hasAnnot() {
        return this.annots != null && !this.annots.isEmpty();
    }

    @Override
    public boolean hasVar(VarTerm t) {
        if (super.hasVar(t)) {
            return true;
        }
        if (this.annots != null) {
            for (Term v : this.annots) {
                if (!v.hasVar(t)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        super.countVars(c);
        if (this.annots != null) {
            for (Term t : this.annots) {
                t.countVars(c);
            }
        }
    }

    @Override
    public boolean importAnnots(Literal p) {
        boolean imported = false;
        if (p.hasAnnot()) {
            if (this.annots == null) {
                this.annots = new ListTermImpl();
            }
            ListTerm tail = this.annots.getLast();
            Iterator i = p.getAnnots().iterator();
            while (i.hasNext()) {
                Term t = (Term)i.next();
                if (!this.annots.contains(t)) {
                    tail = tail.append(t.clone());
                    imported = true;
                    continue;
                }
                i.remove();
            }
        }
        return imported;
    }

    @Override
    public boolean delAnnots(List<Term> l) {
        boolean removed = false;
        if (l != null && this.hasAnnot()) {
            for (Term t : l) {
                boolean r = this.annots.remove(t);
                boolean bl = removed = removed || r;
            }
        }
        return removed;
    }

    @Override
    public ListTerm getAnnots(String functor) {
        ListTermImpl ls = new ListTermImpl();
        if (this.annots != null) {
            ListTerm tail = ls;
            for (Term ta : this.annots) {
                if (!ta.isStructure() || !((Structure)ta).getFunctor().equals(functor)) continue;
                tail = tail.append(ta);
            }
        }
        return ls;
    }

    @Override
    public boolean hasSubsetAnnot(Literal p) {
        if (this.annots == null) {
            return true;
        }
        if (this.hasAnnot() && !p.hasAnnot()) {
            return false;
        }
        for (Term myAnnot : this.annots) {
            if (p.hasAnnot(myAnnot)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasSubsetAnnot(Literal p, Unifier u) {
        if (this.annots == null) {
            return true;
        }
        if (!p.hasAnnot()) {
            return false;
        }
        ListTerm pannots = p.getAnnots().cloneLT();
        VarTerm pTail = null;
        if (pannots.getTail() instanceof VarTerm) {
            pTail = pannots.getTail();
        }
        for (Term annot : this.annots) {
            boolean ok = false;
            Iterator j = pannots.iterator();
            while (j.hasNext() && !ok) {
                Term pAnnot = (Term)j.next();
                if (!u.unifiesNoUndo(annot, pAnnot)) continue;
                ok = true;
                j.remove();
            }
            if (!ok && pTail != null) {
                ListTerm pAnnotsTail = (ListTerm)u.get(pTail);
                if (pAnnotsTail == null) {
                    pAnnotsTail = new ListTermImpl();
                    u.unifies(pTail, pAnnotsTail);
                    pAnnotsTail = (ListTerm)u.get(pTail);
                }
                pAnnotsTail.add(annot);
                ok = true;
            }
            if (ok) continue;
            return false;
        }
        VarTerm thisTail = this.annots.getTail();
        if (thisTail instanceof VarTerm) {
            u.unifies(thisTail, pannots);
        }
        return true;
    }

    @Override
    public void addSource(Term agName) {
        if (agName != null) {
            this.addAnnot(Pred.createSource(agName));
        }
    }

    @Override
    public boolean delSource(Term agName) {
        if (this.annots != null) {
            return this.annots.remove(Pred.createSource(agName));
        }
        return false;
    }

    public static Term createSource(Term source) {
        Structure s = new Structure("source", 1);
        s.addTerm(source);
        return s;
    }

    @Override
    public ListTerm getSources() {
        ListTermImpl ls = new ListTermImpl();
        if (this.annots != null) {
            ListTerm tail = ls;
            for (Term ta : this.annots) {
                Structure tas;
                if (!ta.isStructure() || !(tas = (Structure)ta).getFunctor().equals("source")) continue;
                tail = tail.append(tas.getTerm(0));
            }
        }
        return ls;
    }

    @Override
    public void delSources() {
        if (this.annots != null) {
            Iterator i = this.annots.iterator();
            while (i.hasNext()) {
                Term t = (Term)i.next();
                if (!t.isStructure() || !((Structure)t).getFunctor().equals("source")) continue;
                i.remove();
            }
        }
    }

    @Override
    public boolean hasSource() {
        if (this.annots != null) {
            for (Term ta : this.annots) {
                if (!ta.isStructure() || !((Structure)ta).getFunctor().equals("source")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasSource(Term agName) {
        if (this.annots != null) {
            return this.annots.contains(Pred.createSource(agName));
        }
        return false;
    }

    @Override
    public void makeVarsAnnon(Unifier un) {
        if (this.annots != null) {
            Iterator<ListTerm> i = this.annots.listTermIterator();
            while (i.hasNext()) {
                ListTerm lt = i.next();
                Term ta = lt.getTerm();
                if (ta.isVar() && !ta.isUnnamedVar()) {
                    UnnamedVar uv;
                    VarTerm vt = un.deref((VarTerm)ta);
                    if (vt.isUnnamedVar()) {
                        uv = (UnnamedVar)vt;
                    } else {
                        uv = new UnnamedVar();
                        un.bind(vt, uv);
                    }
                    lt.setTerm(uv);
                    continue;
                }
                if (!ta.isStructure()) continue;
                ((Structure)ta).makeVarsAnnon(un);
            }
        }
        super.makeVarsAnnon(un);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (o instanceof Pred) {
            Pred p = (Pred)o;
            return super.equals(o) && this.hasSubsetAnnot(p) && p.hasSubsetAnnot(this);
        }
        if (o instanceof Atom) {
            return !this.hasAnnot() && super.equals(o);
        }
        return false;
    }

    @Override
    public boolean equalsAsStructure(Object p) {
        return super.equals((Term)p);
    }

    @Override
    public int compareTo(Term t) {
        int c = super.compareTo(t);
        if (c != 0) {
            return c;
        }
        if (t.isPred()) {
            int ots;
            Pred tAsPred = (Pred)t;
            if (this.getAnnots() == null && tAsPred.getAnnots() == null) {
                return 0;
            }
            if (this.getAnnots() == null) {
                return -1;
            }
            if (tAsPred.getAnnots() == null) {
                return 1;
            }
            Iterator pai = tAsPred.getAnnots().iterator();
            for (Term a : this.getAnnots()) {
                c = a.compareTo((Term)pai.next());
                if (c == 0) continue;
                return c;
            }
            int ats = this.getAnnots().size();
            if (ats < (ots = tAsPred.getAnnots().size())) {
                return -1;
            }
            if (ats > ots) {
                return 1;
            }
        }
        return 0;
    }

    @Override
    public Term clone() {
        return new Pred(this);
    }

    public String toStringAsTerm() {
        return super.toString();
    }

    @Override
    public String toString() {
        String s = super.toString();
        if (this.hasAnnot()) {
            s = String.valueOf(s) + this.annots.toString();
        }
        return s;
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = super.getAsDOM(document);
        if (this.hasAnnot()) {
            Element ea = document.createElement("annotations");
            ea.appendChild(this.getAnnots().getAsDOM(document));
            u.appendChild(ea);
        }
        return u;
    }
}

