/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

public final class PredicateIndicator {
    private final String functor;
    private final int arity;
    private final int hash;

    public PredicateIndicator(String functor, int arity) {
        this.functor = functor;
        this.arity = arity;
        this.hash = this.calcHash();
    }

    public PredicateIndicator(String prefix, PredicateIndicator pi2) {
        this.functor = String.valueOf(prefix) + pi2.functor;
        this.arity = pi2.arity;
        this.hash = this.calcHash();
    }

    public String getFunctor() {
        return this.functor;
    }

    public int getArity() {
        return this.arity;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && o instanceof PredicateIndicator && o.hashCode() == this.hashCode()) {
            PredicateIndicator pi2 = (PredicateIndicator)o;
            return this.arity == pi2.arity && this.functor.equals(pi2.functor);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }

    private int calcHash() {
        int PRIME = 31;
        int t = 31 * this.arity;
        if (this.functor != null) {
            t = 31 * t + this.functor.hashCode();
        }
        return t;
    }

    public String toString() {
        return String.valueOf(this.functor) + "/" + this.arity;
    }
}

