/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.VarTerm;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rule
extends LiteralImpl {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Rule.class.getName());
    private LogicalFormula body = null;

    public Rule(Literal head, LogicalFormula body) {
        super(head);
        if (head.isRule()) {
            logger.log(Level.SEVERE, "The rule head (" + head + ") is a rule!", new Exception());
        } else if (this.isInternalAction()) {
            logger.log(Level.SEVERE, "The rule head (" + head + ") can not be an internal action!", new Exception());
        } else if (head == LTrue || head == LFalse) {
            logger.log(Level.SEVERE, "The rule head (" + head + ") can not be a true or false!", new Exception());
        }
        this.body = body;
    }

    @Override
    public boolean isRule() {
        return true;
    }

    @Override
    public boolean equals(Object o) {
        if (o != null && o instanceof Rule) {
            Rule r = (Rule)o;
            return super.equals(o) && this.body.equals(r.body);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.body.hashCode();
    }

    public LogicalFormula getBody() {
        return this.body;
    }

    @Override
    public Rule clone() {
        Rule r = new Rule((Literal)super.clone(), (LogicalFormula)this.body.clone());
        r.predicateIndicatorCache = null;
        r.resetHashCodeCache();
        return r;
    }

    public Literal headClone() {
        return (Literal)super.clone();
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " :- " + this.body;
    }

    @Override
    public boolean hasVar(VarTerm t) {
        if (super.hasVar(t)) {
            return true;
        }
        return this.body.hasVar(t);
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        super.countVars(c);
        this.body.countVars(c);
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("rule");
        Element h = document.createElement("head");
        h.appendChild(super.getAsDOM(document));
        Element b = document.createElement("context");
        b.appendChild(this.body.getAsDOM(document));
        u.appendChild(h);
        u.appendChild(b);
        return u;
    }
}

