/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.Literal;
import jason.asSyntax.Term;
import jason.asSyntax.UnnamedVar;
import jason.asSyntax.VarTerm;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Structure
extends Atom {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(Structure.class.getName());
    protected static final List<Term> emptyTermList = new ArrayList<Term>(0);
    protected static final Term[] emptyTermArray = new Term[0];
    private List<Term> terms;

    public Structure(String functor) {
        super(functor);
        this.terms = new ArrayList<Term>(5);
    }

    public Structure(Literal l) {
        super(l);
        int tss = l.getArity();
        this.terms = new ArrayList<Term>(tss);
        int i = 0;
        while (i < tss) {
            this.terms.add(l.getTerm(i).clone());
            ++i;
        }
    }

    public Structure(String functor, int termsSize) {
        super(functor);
        if (termsSize > 0) {
            this.terms = new ArrayList<Term>(termsSize);
        }
    }

    public static Structure parse(String sTerm) {
        as2j parser = new as2j(new StringReader(sTerm));
        try {
            Term t = parser.term();
            if (t instanceof Structure) {
                return (Structure)t;
            }
            return new Structure((Atom)t);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing structure " + sTerm, e2);
            return null;
        }
    }

    @Override
    protected int calcHashCode() {
        int result = super.calcHashCode();
        int ts = this.getArity();
        int i = 0;
        while (i < ts) {
            result = 7 * result + this.getTerm(i).hashCode();
            ++i;
        }
        return result;
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (t instanceof Structure) {
            Structure tAsStruct = (Structure)t;
            if (tAsStruct.isVar()) {
                return ((VarTerm)t).equals(this);
            }
            int ts = this.getArity();
            if (ts != tAsStruct.getArity()) {
                return false;
            }
            if (!this.getFunctor().equals(tAsStruct.getFunctor())) {
                return false;
            }
            int i = 0;
            while (i < ts) {
                if (!this.getTerm(i).equals(tAsStruct.getTerm(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (t instanceof Atom) {
            return super.equals(t);
        }
        return false;
    }

    @Override
    public int compareTo(Term t) {
        int c = super.compareTo(t);
        if (c != 0) {
            return c;
        }
        if (t.isStructure()) {
            int oa;
            Structure tAsStruct = (Structure)t;
            int ma = this.getArity();
            if (ma < (oa = tAsStruct.getArity())) {
                return -1;
            }
            if (ma > oa) {
                return 1;
            }
            int i = 0;
            while (i < ma && i < oa) {
                c = this.getTerm(i).compareTo(tAsStruct.getTerm(i));
                if (c != 0) {
                    return c;
                }
                ++i;
            }
        }
        return 0;
    }

    @Override
    public boolean apply(Unifier u) {
        boolean r = false;
        int tss = this.getArity();
        int i = 0;
        while (i < tss) {
            boolean tr = this.getTerm(i).apply(u);
            r = r || tr;
            ++i;
        }
        if (r) {
            this.resetHashCodeCache();
        }
        return r;
    }

    @Override
    public Term clone() {
        return new Structure(this);
    }

    @Override
    public void addTerm(Term t) {
        if (t == null) {
            return;
        }
        this.terms.add(t);
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
    }

    @Override
    public void delTerm(int index) {
        this.terms.remove(index);
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
    }

    @Override
    public Literal addTerms(Term ... ts) {
        Term[] termArray = ts;
        int n = ts.length;
        int n2 = 0;
        while (n2 < n) {
            Term t = termArray[n2];
            this.terms.add(t);
            ++n2;
        }
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
        return this;
    }

    @Override
    public Literal addTerms(List<Term> l) {
        for (Term t : l) {
            this.terms.add(t);
        }
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
        return this;
    }

    @Override
    public Literal setTerms(List<Term> l) {
        this.terms = l;
        this.predicateIndicatorCache = null;
        this.resetHashCodeCache();
        return this;
    }

    @Override
    public void setTerm(int i, Term t) {
        this.terms.set(i, t);
        this.resetHashCodeCache();
    }

    @Override
    public Term getTerm(int i) {
        return this.terms.get(i);
    }

    @Override
    public int getArity() {
        if (this.terms == null) {
            return 0;
        }
        return this.terms.size();
    }

    public int getTermsSize() {
        return this.getArity();
    }

    @Override
    public List<Term> getTerms() {
        return this.terms;
    }

    @Override
    public boolean hasTerm() {
        return this.getArity() > 0;
    }

    @Override
    public boolean isStructure() {
        return true;
    }

    @Override
    public boolean isAtom() {
        return !this.hasTerm();
    }

    @Override
    public boolean isGround() {
        int size = this.getArity();
        int i = 0;
        while (i < size) {
            if (!this.getTerm(i).isGround()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void makeVarsAnnon() {
        this.makeVarsAnnon(new Unifier());
    }

    @Override
    public void makeVarsAnnon(Unifier un) {
        int size = this.getArity();
        int i = 0;
        while (i < size) {
            Structure tis;
            Term ti = this.getTerm(i);
            if (ti.isVar() && !ti.isUnnamedVar()) {
                UnnamedVar uv;
                VarTerm vt = un.deref((VarTerm)ti);
                if (vt.isUnnamedVar()) {
                    uv = (UnnamedVar)vt;
                } else {
                    uv = new UnnamedVar();
                    un.bind(vt, uv);
                }
                this.setTerm(i, uv);
            } else if (ti.isStructure() && (tis = (Structure)ti).hasTerm()) {
                tis.makeVarsAnnon(un);
            }
            ++i;
        }
        this.resetHashCodeCache();
    }

    @Override
    public void makeTermsAnnon() {
        int size = this.getArity();
        int i = 0;
        while (i < size) {
            this.setTerm(i, new UnnamedVar());
            ++i;
        }
        this.resetHashCodeCache();
    }

    @Override
    public boolean hasVar(VarTerm t) {
        int size = this.getArity();
        int i = 0;
        while (i < size) {
            if (this.getTerm(i).hasVar(t)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public List<VarTerm> getSingletonVars() {
        HashMap<VarTerm, Integer> all = new HashMap<VarTerm, Integer>();
        this.countVars(all);
        ArrayList<VarTerm> r = new ArrayList<VarTerm>();
        for (VarTerm k : all.keySet()) {
            if ((Integer)all.get(k) != 1 || k.isUnnamedVar()) continue;
            r.add(k);
        }
        return r;
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        int tss = this.getArity();
        int i = 0;
        while (i < tss) {
            this.getTerm(i).countVars(c);
            ++i;
        }
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.getFunctor() != null) {
            s.append(this.getFunctor());
        }
        if (this.getArity() > 0) {
            s.append('(');
            Iterator<Term> i = this.terms.iterator();
            while (i.hasNext()) {
                s.append(i.next());
                if (!i.hasNext()) continue;
                s.append(',');
            }
            s.append(')');
        }
        return s.toString();
    }

    @Override
    public Element getAsDOM(Document document) {
        Element u = document.createElement("structure");
        u.setAttribute("functor", this.getFunctor());
        if (this.hasTerm()) {
            Element ea = document.createElement("arguments");
            for (Term t : this.getTerms()) {
                ea.appendChild(t.getAsDOM(document));
            }
            u.appendChild(ea);
        }
        return u;
    }

    public static /* bridge */ /* synthetic */ Term parse(String string2) {
        return Structure.parse(string2);
    }
}

