/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Unifier;
import jason.asSyntax.Literal;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Trigger
implements Cloneable {
    private static Logger logger = Logger.getLogger(Trigger.class.getName());
    private TEOperator operator = TEOperator.add;
    private TEType type = TEType.belief;
    private Literal literal;
    private PredicateIndicator piCache = null;

    public Trigger(TEOperator op, TEType t, Literal l) {
        this.literal = l;
        this.type = t;
        this.setTrigOp(op);
    }

    public static Trigger parseTrigger(String sTe) {
        as2j parser = new as2j(new StringReader(sTe));
        try {
            return parser.trigger();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing trigger" + sTe, e2);
            return null;
        }
    }

    public void setTrigOp(TEOperator op) {
        this.operator = op;
        this.piCache = null;
    }

    public boolean sameType(Trigger e2) {
        return this.operator == e2.operator && this.type == e2.type;
    }

    public boolean equals(Object o) {
        if (o != null && o instanceof Trigger) {
            Trigger t = (Trigger)o;
            return this.operator == t.operator && this.type == t.type && this.literal.equals(t.getLiteral());
        }
        return false;
    }

    public int hashCode() {
        return this.getPredicateIndicator().hashCode();
    }

    public boolean isAchvGoal() {
        return this.type == TEType.achieve;
    }

    public boolean isGoal() {
        return this.type == TEType.achieve || this.type == TEType.test;
    }

    public TEType getType() {
        return this.type;
    }

    public boolean isAddition() {
        return this.operator == TEOperator.add;
    }

    public Trigger clone() {
        Trigger c = new Trigger(this.operator, this.type, this.literal.copy());
        c.piCache = this.piCache;
        return c;
    }

    public PredicateIndicator getPredicateIndicator() {
        if (this.piCache == null) {
            this.piCache = new PredicateIndicator(String.valueOf(this.operator.toString()) + (Object)((Object)this.type) + this.literal.getFunctor(), this.literal.getArity());
        }
        return this.piCache;
    }

    public boolean apply(Unifier u) {
        return this.literal.apply(u);
    }

    public Literal getLiteral() {
        return this.literal;
    }

    public void setLiteral(Literal literal2) {
        this.literal = literal2;
    }

    public String toString() {
        return String.valueOf(this.operator.toString()) + (Object)((Object)this.type) + this.literal;
    }

    public Element getAsDOM(Document document) {
        Element e2 = document.createElement("trigger");
        e2.setAttribute("operator", this.operator.toString());
        e2.setAttribute("type", this.type.toString());
        e2.appendChild(this.literal.getAsDOM(document));
        return e2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TEOperator {
        add{

            public String toString() {
                return "+";
            }
        }
        ,
        del{

            public String toString() {
                return "-";
            }
        };

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TEType {
        belief{

            public String toString() {
                return "";
            }
        }
        ,
        achieve{

            public String toString() {
                return "!";
            }
        }
        ,
        test{

            public String toString() {
                return "?";
            }
        };

    }
}

