/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax;

import jason.asSemantics.Agent;
import jason.asSemantics.Unifier;
import jason.asSyntax.Atom;
import jason.asSyntax.ListTerm;
import jason.asSyntax.Literal;
import jason.asSyntax.LiteralImpl;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.ObjectTerm;
import jason.asSyntax.PlanBody;
import jason.asSyntax.Pred;
import jason.asSyntax.PredicateIndicator;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.asSyntax.parser.as2j;
import java.io.StringReader;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VarTerm
extends LiteralImpl
implements NumberTerm,
ListTerm,
StringTerm,
ObjectTerm,
PlanBody {
    private static final long serialVersionUID = 1L;
    private static Logger logger = Logger.getLogger(VarTerm.class.getName());
    private Term value = null;

    public VarTerm(String s) {
        super(s);
        if (s != null && Character.isLowerCase(s.charAt(0))) {
            logger.warning("Are you sure you want to create a VarTerm that begins with lowercase (" + s + ")? Should it be a Term instead?");
            Exception e2 = new Exception("stack");
            e2.printStackTrace();
        }
    }

    public static VarTerm parseVar(String sVar) {
        as2j parser = new as2j(new StringReader(sVar));
        try {
            return parser.var();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing var " + sVar, e2);
            return null;
        }
    }

    @Override
    public Term clone() {
        if (this.value != null) {
            return this.value.clone();
        }
        VarTerm t = new VarTerm(super.getFunctor());
        t.srcInfo = this.srcInfo;
        if (this.hasAnnot()) {
            t.setAnnots(this.getAnnots().cloneLT());
        }
        return t;
    }

    @Override
    public PlanBody clonePB() {
        return (PlanBody)this.clone();
    }

    @Override
    public ListTerm cloneLT() {
        return (ListTerm)this.clone();
    }

    @Override
    public boolean isVar() {
        return this.value == null;
    }

    @Override
    public boolean isUnnamedVar() {
        return false;
    }

    @Override
    public boolean isGround() {
        return this.value != null && this.value.isGround();
    }

    public boolean setValue(Term vl) {
        if (vl.isVar()) {
            logger.log(Level.WARNING, "Attempted set a variable as a value for a variable, in " + this.getFunctor(), new Exception());
            return false;
        }
        if ((vl = vl.clone()).isPred() && this.hasAnnot()) {
            ((Pred)vl).addAnnots(this.getAnnots());
        }
        this.value = vl;
        this.resetHashCodeCache();
        return true;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    @Override
    public boolean apply(Unifier u) {
        if (this.value == null) {
            Term vl = u.get(this);
            if (vl != null) {
                if (!vl.hasVar(this)) {
                    this.setValue(vl);
                    this.value.apply(u);
                    return true;
                }
                logger.warning("Value of variable contains itself, variable " + super.getFunctor() + " " + super.getSrcInfo() + ", value=" + this.value);
                return false;
            }
        } else {
            return this.getValue().apply(u);
        }
        return false;
    }

    public Term getValue() {
        return this.value;
    }

    @Override
    public boolean equals(Object t) {
        if (t == null) {
            return false;
        }
        if (t == this) {
            return true;
        }
        if (t instanceof Term) {
            VarTerm tAsVT;
            Term vl = this.getValue();
            if (vl != null) {
                return vl.equals(t);
            }
            if (t instanceof VarTerm && (tAsVT = (VarTerm)t).getValue() == null) {
                return this.getFunctor().equals(((VarTerm)t).getFunctor());
            }
        }
        return false;
    }

    @Override
    public int compareTo(Term t) {
        if (this.value != null) {
            return this.value.compareTo(t);
        }
        if (t.isUnnamedVar()) {
            return -1;
        }
        return super.compareTo(t);
    }

    @Override
    public String getFunctor() {
        if (this.value == null) {
            return super.getFunctor();
        }
        if (this.value instanceof Atom) {
            return ((Atom)this.getValue()).getFunctor();
        }
        return null;
    }

    @Override
    public PredicateIndicator getPredicateIndicator() {
        if (this.value != null && this.value.isStructure()) {
            return ((Structure)this.value).getPredicateIndicator();
        }
        if (this.predicateIndicatorCache == null) {
            this.predicateIndicatorCache = new PredicateIndicator(this.getFunctor(), 0);
        }
        return this.predicateIndicatorCache;
    }

    @Override
    public int hashCode() {
        if (this.value != null) {
            return this.value.hashCode();
        }
        return this.getFunctor().hashCode();
    }

    @Override
    public Iterator<Unifier> logicalConsequence(Agent ag, Unifier un) {
        if (this.value != null && this.value instanceof LogicalFormula) {
            return ((LogicalFormula)this.value).logicalConsequence(ag, un);
        }
        Term t = this.clone();
        if (t instanceof VarTerm) {
            VarTerm c = (VarTerm)t;
            c.apply(un);
            if (c.hasValue() && c.getValue() instanceof LogicalFormula) {
                return ((LogicalFormula)c.getValue()).logicalConsequence(ag, un);
            }
            return super.logicalConsequence(ag, un);
        }
        return null;
    }

    @Override
    public Term getTerm(int i) {
        if (this.value != null && this.value.isStructure()) {
            return ((Structure)this.getValue()).getTerm(i);
        }
        return null;
    }

    @Override
    public void addTerm(Term t) {
        if (this.value != null && this.value.isStructure()) {
            ((Structure)this.getValue()).addTerm(t);
        }
    }

    @Override
    public int getArity() {
        if (this.value != null && this.value.isStructure()) {
            return ((Structure)this.getValue()).getArity();
        }
        return 0;
    }

    @Override
    public List<Term> getTerms() {
        if (this.value != null && this.value.isStructure()) {
            return ((Structure)this.getValue()).getTerms();
        }
        return null;
    }

    @Override
    public Literal setTerms(List<Term> l) {
        if (this.value != null && this.value.isStructure()) {
            return ((Structure)this.getValue()).setTerms(l);
        }
        return this;
    }

    @Override
    public void setTerm(int i, Term t) {
        if (this.value != null && this.value.isStructure()) {
            ((Structure)this.getValue()).setTerm(i, t);
        }
    }

    @Override
    public Literal addTerms(List<Term> l) {
        if (this.value != null && this.value.isStructure()) {
            return ((Structure)this.getValue()).addTerms(l);
        }
        return this;
    }

    @Override
    public Term[] getTermsArray() {
        if (this.value != null && this.value.isStructure()) {
            return ((Structure)this.getValue()).getTermsArray();
        }
        return null;
    }

    @Override
    public boolean isInternalAction() {
        return this.value != null && this.getValue().isInternalAction();
    }

    @Override
    public boolean isList() {
        return this.value != null && this.getValue().isList();
    }

    @Override
    public boolean isString() {
        return this.value != null && this.getValue().isString();
    }

    @Override
    public boolean isPlanBody() {
        return this.value != null && this.getValue().isPlanBody();
    }

    @Override
    public boolean isNumeric() {
        return this.value != null && this.value.isNumeric();
    }

    @Override
    public boolean isPred() {
        return this.value != null && this.getValue().isPred();
    }

    @Override
    public boolean isLiteral() {
        return this.value != null && this.getValue().isLiteral();
    }

    @Override
    public boolean isStructure() {
        return this.value != null && this.getValue().isStructure();
    }

    @Override
    public boolean isAtom() {
        return this.value != null && this.getValue().isAtom();
    }

    @Override
    public boolean isRule() {
        return this.value != null && this.getValue().isRule();
    }

    @Override
    public boolean isArithExpr() {
        return this.value != null && this.value.isArithExpr();
    }

    @Override
    public boolean hasVar(VarTerm t) {
        if (this.value == null) {
            return this.equals(t);
        }
        return this.value.hasVar(t);
    }

    @Override
    public void countVars(Map<VarTerm, Integer> c) {
        if (this.value == null) {
            int n = c.containsKey(this) ? c.get(this) : 0;
            c.put(this, n + 1);
            super.countVars(c);
        } else {
            this.value.countVars(c);
        }
    }

    @Override
    public String toString() {
        if (this.value == null) {
            String s = this.getFunctor();
            if (this.hasAnnot()) {
                s = String.valueOf(s) + this.getAnnots();
            }
            return s;
        }
        return this.value.toString();
    }

    @Override
    public void setAnnots(ListTerm l) {
        if (this.value != null && this.value.isPred()) {
            ((Pred)this.value).setAnnots(l);
        } else {
            super.setAnnots(l);
        }
    }

    @Override
    public boolean importAnnots(Literal p) {
        if (this.value != null && this.getValue().isPred()) {
            return ((Pred)this.getValue()).importAnnots(p);
        }
        return super.importAnnots(p);
    }

    @Override
    public boolean addAnnot(Term t) {
        if (this.value != null && this.getValue().isPred()) {
            return ((Pred)this.getValue()).addAnnot(t);
        }
        return super.addAnnot(t);
    }

    @Override
    public Literal addAnnots(List<Term> l) {
        if (this.value != null && this.getValue().isPred()) {
            return ((Pred)this.getValue()).addAnnots(l);
        }
        return super.addAnnots(l);
    }

    @Override
    public void clearAnnots() {
        if (this.value != null && this.getValue().isPred()) {
            ((Pred)this.getValue()).clearAnnots();
        } else {
            super.clearAnnots();
        }
    }

    @Override
    public boolean delAnnots(List<Term> l) {
        if (this.value != null && this.getValue().isLiteral()) {
            return ((Literal)this.getValue()).delAnnots(l);
        }
        return super.delAnnots(l);
    }

    @Override
    public void delAnnot(Term t) {
        if (this.value != null && this.getValue().isPred()) {
            ((Pred)this.getValue()).delAnnot(t);
        } else {
            super.delAnnot(t);
        }
    }

    @Override
    public boolean hasAnnot(Term t) {
        if (this.value != null && this.getValue().isLiteral()) {
            return ((Literal)this.getValue()).hasAnnot(t);
        }
        return super.hasAnnot(t);
    }

    @Override
    public boolean hasAnnot() {
        if (this.value != null && this.getValue().isLiteral()) {
            return ((Literal)this.getValue()).hasAnnot();
        }
        return super.hasAnnot();
    }

    @Override
    public boolean hasSubsetAnnot(Literal p) {
        if (this.value != null && this.value.isLiteral()) {
            return ((Literal)this.value).hasSubsetAnnot(p);
        }
        return super.hasSubsetAnnot(p);
    }

    @Override
    public boolean hasSubsetAnnot(Literal p, Unifier u) {
        if (this.value != null && this.value.isLiteral()) {
            return ((Literal)this.value).hasSubsetAnnot(p, u);
        }
        return super.hasSubsetAnnot(p, u);
    }

    @Override
    public ListTerm getAnnots() {
        if (this.value != null && this.getValue().isLiteral()) {
            return ((Literal)this.getValue()).getAnnots();
        }
        return super.getAnnots();
    }

    @Override
    public void addSource(Term t) {
        if (this.value != null && this.getValue().isPred()) {
            ((Pred)this.getValue()).addSource(t);
        } else {
            super.addSource(t);
        }
    }

    @Override
    public boolean delSource(Term s) {
        if (this.value != null && this.getValue().isPred()) {
            return ((Pred)this.getValue()).delSource(s);
        }
        return super.delSource(s);
    }

    @Override
    public void delSources() {
        if (this.value != null && this.getValue().isPred()) {
            ((Pred)this.getValue()).delSources();
        } else {
            super.delSources();
        }
    }

    @Override
    public ListTerm getSources() {
        if (this.value != null && this.getValue().isLiteral()) {
            return ((Literal)this.getValue()).getSources();
        }
        return super.getSources();
    }

    @Override
    public boolean hasSource() {
        if (this.value != null && this.getValue().isLiteral()) {
            return ((Literal)this.getValue()).hasSource();
        }
        return super.hasSource();
    }

    @Override
    public boolean hasSource(Term s) {
        if (this.value != null && this.getValue().isLiteral()) {
            return ((Literal)this.getValue()).hasSource(s);
        }
        return super.hasSource(s);
    }

    @Override
    public boolean negated() {
        return this.value != null && this.getValue().isLiteral() && ((Literal)this.getValue()).negated();
    }

    @Override
    public boolean canBeAddedInBB() {
        if (this.value != null && this.getValue().isLiteral()) {
            return ((Literal)this.getValue()).canBeAddedInBB();
        }
        return false;
    }

    @Override
    public double solve() {
        if (this.value != null && this.value.isNumeric()) {
            return ((NumberTerm)this.value).solve();
        }
        if (this.hasValue()) {
            logger.log(Level.SEVERE, String.valueOf(this.getErrorMsg()) + " Error getting numerical value of VarTerm " + super.getFunctor() + ", the variable value (" + this.value + ") is not a number.", new Exception());
        } else {
            logger.log(Level.SEVERE, String.valueOf(this.getErrorMsg()) + " Error getting numerical value of VarTerm " + super.getFunctor() + ", the variable hasn't a value.", new Exception());
        }
        return 0.0;
    }

    @Override
    public void add(int index, Term o) {
        if (this.value != null && this.getValue().isList()) {
            ((ListTerm)this.getValue()).add(index, o);
        }
    }

    @Override
    public boolean add(Term o) {
        return this.value != null && this.getValue().isList() && ((ListTerm)this.getValue()).add(o);
    }

    @Override
    public boolean addAll(Collection c) {
        return this.value != null && this.getValue().isList() && ((ListTerm)this.getValue()).addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection c) {
        return this.value != null && this.getValue().isList() && ((ListTerm)this.getValue()).addAll(index, c);
    }

    @Override
    public void clear() {
        if (this.value != null && this.getValue().isList()) {
            ((ListTerm)this.getValue()).clear();
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.value != null && this.getValue().isList() && ((ListTerm)this.getValue()).contains(o);
    }

    @Override
    public boolean containsAll(Collection c) {
        return this.value != null && this.getValue().isList() && ((ListTerm)this.getValue()).containsAll(c);
    }

    @Override
    public Term get(int index) {
        if (this.value != null && this.getValue().isList()) {
            return (Term)((ListTerm)this.getValue()).get(index);
        }
        return null;
    }

    @Override
    public int indexOf(Object o) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).indexOf(o);
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).lastIndexOf(o);
        }
        return -1;
    }

    @Override
    public Iterator<Term> iterator() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).iterator();
        }
        return null;
    }

    @Override
    public ListIterator<Term> listIterator() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).listIterator();
        }
        return null;
    }

    @Override
    public ListIterator<Term> listIterator(int index) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).listIterator(index);
        }
        return null;
    }

    @Override
    public Term remove(int index) {
        if (this.value != null && this.getValue().isList()) {
            return (Term)((ListTerm)this.getValue()).remove(index);
        }
        return null;
    }

    @Override
    public boolean remove(Object o) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).remove(o);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection c) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).removeAll(c);
        }
        return false;
    }

    @Override
    public boolean retainAll(Collection c) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).retainAll(c);
        }
        return false;
    }

    @Override
    public Term set(int index, Term o) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).set(index, o);
        }
        return null;
    }

    @Override
    public List<Term> subList(int arg0, int arg1) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).subList(arg0, arg1);
        }
        return null;
    }

    @Override
    public Object[] toArray() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).toArray();
        }
        return null;
    }

    @Override
    public Object[] toArray(Object[] arg0) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).toArray(arg0);
        }
        return null;
    }

    @Override
    public void setTerm(Term t) {
        if (this.value != null && this.getValue().isList()) {
            ((ListTerm)this.getValue()).setTerm(t);
        }
    }

    @Override
    public void setNext(Term t) {
        if (this.value != null && this.getValue().isList()) {
            ((ListTerm)this.getValue()).setNext(t);
        }
    }

    @Override
    public ListTerm append(Term t) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).append(t);
        }
        return null;
    }

    @Override
    public ListTerm concat(ListTerm lt) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).concat(lt);
        }
        return null;
    }

    @Override
    public ListTerm reverse() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).reverse();
        }
        return null;
    }

    @Override
    public ListTerm union(ListTerm lt) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).union(lt);
        }
        return null;
    }

    @Override
    public ListTerm intersection(ListTerm lt) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).intersection(lt);
        }
        return null;
    }

    @Override
    public ListTerm difference(ListTerm lt) {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).difference(lt);
        }
        return null;
    }

    @Override
    public List<Term> getAsList() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).getAsList();
        }
        return null;
    }

    @Override
    public ListTerm getLast() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).getLast();
        }
        return null;
    }

    @Override
    public ListTerm getNext() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).getNext();
        }
        return null;
    }

    @Override
    public Term getTerm() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).getTerm();
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.value != null && this.getValue().isList() && ((ListTerm)this.getValue()).isEmpty();
    }

    @Override
    public boolean isEnd() {
        return this.value != null && this.getValue().isList() && ((ListTerm)this.getValue()).isEnd();
    }

    @Override
    public boolean isTail() {
        return this.value != null && this.getValue().isList() && ((ListTerm)this.getValue()).isTail();
    }

    @Override
    public void setTail(VarTerm v) {
        if (this.value != null && this.getValue().isList()) {
            ((ListTerm)this.getValue()).setTail(v);
        }
    }

    @Override
    public VarTerm getTail() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).getTail();
        }
        return null;
    }

    @Override
    public Iterator<ListTerm> listTermIterator() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).listTermIterator();
        }
        return null;
    }

    @Override
    public int size() {
        if (this.value != null && this.getValue().isList()) {
            return ((ListTerm)this.getValue()).size();
        }
        return -1;
    }

    @Override
    public String getString() {
        if (this.value != null && this.getValue().isString()) {
            return ((StringTerm)this.getValue()).getString();
        }
        return null;
    }

    @Override
    public int length() {
        if (this.value != null && this.getValue().isString()) {
            return ((StringTerm)this.getValue()).length();
        }
        return -1;
    }

    @Override
    public Object getObject() {
        if (this.value != null && this.getValue() instanceof ObjectTerm) {
            return ((ObjectTerm)this.getValue()).getObject();
        }
        return null;
    }

    @Override
    public PlanBody.BodyType getBodyType() {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).getBodyType();
        }
        return PlanBody.BodyType.none;
    }

    @Override
    public Term getBodyTerm() {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).getBodyTerm();
        }
        return null;
    }

    @Override
    public PlanBody getBodyNext() {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).getBodyNext();
        }
        return null;
    }

    @Override
    public PlanBody getLastBody() {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).getLastBody();
        }
        return null;
    }

    @Override
    public boolean isEmptyBody() {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).isEmptyBody();
        }
        return true;
    }

    @Override
    public int getPlanSize() {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).getPlanSize();
        }
        return 0;
    }

    @Override
    public void setBodyType(PlanBody.BodyType bt) {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            ((PlanBody)this.getValue()).setBodyType(bt);
        }
    }

    @Override
    public void setBodyTerm(Term t) {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            ((PlanBody)this.getValue()).setBodyTerm(t);
        }
    }

    @Override
    public void setBodyNext(PlanBody bl) {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            ((PlanBody)this.getValue()).setBodyNext(bl);
        }
    }

    @Override
    public boolean isBodyTerm() {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).isBodyTerm();
        }
        return false;
    }

    @Override
    public void setAsBodyTerm(boolean b) {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            ((PlanBody)this.getValue()).setAsBodyTerm(b);
        }
    }

    @Override
    public boolean add(PlanBody bl) {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).add(bl);
        }
        return false;
    }

    @Override
    public boolean add(int index, PlanBody bl) {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).add(index, bl);
        }
        return false;
    }

    @Override
    public Term removeBody(int index) {
        if (this.value != null && this.getValue() instanceof PlanBody) {
            return ((PlanBody)this.getValue()).removeBody(index);
        }
        return null;
    }

    @Override
    public Element getAsDOM(Document document) {
        if (this.hasValue()) {
            return this.value.getAsDOM(document);
        }
        Element u = document.createElement("var-term");
        u.setAttribute("functor", this.getFunctor());
        if (this.hasAnnot()) {
            Element ea = document.createElement("annotations");
            ea.appendChild(this.getAnnots().getAsDOM(document));
            u.appendChild(ea);
        }
        return u;
    }
}

