/*
 * Decompiled with CFR 0.152.
 */
package jason.asSyntax.directives;

import jason.asSemantics.Agent;
import jason.asSemantics.ArithFunction;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.Pred;
import jason.asSyntax.StringTerm;
import jason.asSyntax.directives.Directive;
import jason.functions.Abs;
import jason.functions.Average;
import jason.functions.Length;
import jason.functions.Max;
import jason.functions.Min;
import jason.functions.Random;
import jason.functions.Round;
import jason.functions.Sqrt;
import jason.functions.Sum;
import jason.functions.ceil;
import jason.functions.e;
import jason.functions.floor;
import jason.functions.log;
import jason.functions.pi;
import jason.functions.time;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FunctionRegister
implements Directive {
    static Logger logger = Logger.getLogger(FunctionRegister.class.getName());
    private static Map<String, ArithFunction> functions = new HashMap<String, ArithFunction>();

    static {
        FunctionRegister.addFunction(Abs.class);
        FunctionRegister.addFunction(Max.class);
        FunctionRegister.addFunction(Min.class);
        FunctionRegister.addFunction(Sum.class);
        FunctionRegister.addFunction(Average.class);
        FunctionRegister.addFunction(Length.class);
        FunctionRegister.addFunction(Random.class);
        FunctionRegister.addFunction(Round.class);
        FunctionRegister.addFunction(Sqrt.class);
        FunctionRegister.addFunction(pi.class);
        FunctionRegister.addFunction(e.class);
        FunctionRegister.addFunction(floor.class);
        FunctionRegister.addFunction(ceil.class);
        FunctionRegister.addFunction(log.class);
        FunctionRegister.addFunction(time.class);
    }

    private static void addFunction(Class<? extends ArithFunction> c) {
        try {
            ArithFunction af = c.newInstance();
            functions.put(af.getName(), af);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error registering function " + c.getName(), e2);
        }
    }

    public static String checkFunctionName(String fName) {
        if (functions.get(fName) != null) {
            return "Can not register the function " + fName + "  twice!";
        }
        if (fName.indexOf(".") < 0) {
            return "The function " + fName + " was not registered! A function must have a '.' in its name.";
        }
        if (fName.startsWith(".")) {
            return "The function " + fName + " was not registered! An user function name can not start with '.'.";
        }
        return null;
    }

    public static ArithFunction getFunction(String function, int arity) {
        ArithFunction af = functions.get(function);
        if (af != null && af.checkArity(arity)) {
            return af;
        }
        return null;
    }

    @Override
    public Agent process(Pred directive, Agent outerContent, Agent innerContent) {
        if (outerContent == null) {
            return null;
        }
        try {
            String id = ((StringTerm)directive.getTerm(0)).getString();
            if (directive.getArity() == 1) {
                outerContent.addFunction(Class.forName(id));
            } else if (directive.getArity() == 3) {
                int arity = (int)((NumberTerm)directive.getTerm(1)).solve();
                String predicate = ((StringTerm)directive.getTerm(2)).getString();
                outerContent.addFunction(id, arity, predicate);
            } else {
                logger.log(Level.SEVERE, "Wrong number of arguments for register_function " + directive);
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error processing directive register_function.", e2);
        }
        return null;
    }
}

