/*
 * Decompiled with CFR 0.152.
 */
package jason.asunit;

import jason.JasonException;
import jason.RevisionFailedException;
import jason.asSemantics.Agent;
import jason.asSemantics.Circumstance;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.Literal;
import jason.asSyntax.LogicalFormula;
import jason.asSyntax.Structure;
import jason.asSyntax.Trigger;
import jason.asSyntax.parser.ParseException;
import jason.asunit.Condition;
import jason.asunit.TestArch;
import jason.bb.BeliefBase;
import jason.infra.centralised.RunCentralisedMAS;
import jason.runtime.Settings;
import java.io.StringReader;
import java.util.logging.Level;
import org.junit.Assert;

public class TestAgent
extends Agent {
    static {
        new RunCentralisedMAS();
    }

    public TestAgent() {
        this(null);
    }

    public TestAgent(String agName) {
        try {
            TestArch arch = null;
            arch = agName == null ? new TestArch() : new TestArch(agName);
            TransitionSystem ts = new TransitionSystem(this, new Circumstance(), new Settings(), arch.getUserAgArch());
            this.setTS(ts);
            arch.getUserAgArch().setTS(ts);
            this.initAg(null);
        }
        catch (JasonException e2) {
            this.logger.log(Level.SEVERE, "Error creating TestArch", e2);
        }
    }

    public boolean parseAScode(String aslCode) {
        try {
            this.getPL().clear();
            this.setASLSrc("stringcode");
            this.parseAS(new StringReader(aslCode));
            this.addInitialBelsInBB();
            this.addInitialGoalsInTS();
            this.setASLSrc("kqmlPlans.asl");
            this.parseAS(JasonException.class.getResource("/asl/kqmlPlans.asl"));
            this.setASLSrc("stringcode");
            return true;
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error parsing\n" + aslCode + ": " + e2.getMessage());
            return false;
        }
    }

    public TestArch getArch() {
        return (TestArch)this.getTS().getUserAgArch().getArchInfraTier();
    }

    public void setDebugMode(boolean on) {
        if (on) {
            this.getTS().getLogger().setLevel(Level.FINE);
            this.getArch().getLogger().setLevel(Level.FINE);
            this.getTS().getAg().getLogger().setLevel(Level.FINE);
        } else {
            this.getTS().getLogger().setLevel(Level.INFO);
        }
    }

    public void addGoal(String g) {
        try {
            this.addGoal(ASSyntax.parseLiteral(g));
        }
        catch (Exception e2) {
            Assert.fail((String)("Parsing '" + g + "' as literal for a goal failed!"));
        }
    }

    public void addGoal(Literal g) {
        this.getTS().getC().addAchvGoal(g, Intention.EmptyInt);
    }

    public void addBel(String bel) {
        try {
            super.addBel(ASSyntax.parseLiteral(bel));
        }
        catch (ParseException e2) {
            Assert.fail((String)("Parsing '" + bel + "' as a belief!"));
        }
        catch (RevisionFailedException e3) {
            Assert.fail((String)("BRF error for adding '" + bel + "!"));
        }
    }

    public void delBel(String bel) {
        try {
            Literal l = ASSyntax.parseLiteral(bel);
            if (!l.hasSource()) {
                l.addAnnot(BeliefBase.TSelf);
            }
            super.delBel(l);
        }
        catch (ParseException e2) {
            Assert.fail((String)("Parsing '" + bel + "' as a belief!"));
        }
        catch (RevisionFailedException e3) {
            Assert.fail((String)("BRF error for deleting '" + bel + "!"));
        }
    }

    public void assertBel(String formula, int maxCycles) {
        try {
            this.assertBel(ASSyntax.parseFormula(formula), maxCycles);
        }
        catch (ParseException e2) {
            Assert.fail((String)("Parsing '" + formula + "' as a formula failed!"));
        }
    }

    public void assertBel(final LogicalFormula belief, int maxCycles) {
        Condition c = new Condition(){

            public boolean test(TestArch arch) {
                return TestAgent.this.believes(belief, new Unifier());
            }
        };
        if (!this.assertMaxCyclesAndAnotherCondition(c, maxCycles)) {
            Assert.fail((String)("failed assertBel(" + belief + ")"));
        }
    }

    public void assertEvt(String te, int maxCycles) {
        try {
            this.assertEvt(ASSyntax.parseTrigger(te), maxCycles);
        }
        catch (ParseException e2) {
            Assert.fail((String)("Parsing '" + te + "' as trigger failed!"));
        }
    }

    public void assertEvt(Trigger te, int maxCycles) {
        final Event evt = new Event(te, Intention.EmptyInt);
        Condition c = new Condition(){

            public boolean test(TestArch arch) {
                return TestAgent.this.getTS().getC().getEvents().contains(evt);
            }
        };
        if (!this.assertMaxCyclesAndAnotherCondition(c, maxCycles)) {
            Assert.fail((String)("failed assertEvt(" + te + ")"));
        }
    }

    public void assertAct(String act, int maxCycles) {
        try {
            this.assertAct(ASSyntax.parseStructure(act), maxCycles);
        }
        catch (ParseException e2) {
            Assert.fail((String)("Parsing '" + act + "' as action failed!"));
        }
    }

    public void assertAct(final Structure act, int maxCycles) {
        Condition c = new Condition(){

            public boolean test(TestArch arch) {
                return arch.getActions().contains(act);
            }
        };
        if (!this.assertMaxCyclesAndAnotherCondition(c, maxCycles)) {
            Assert.fail((String)("failed assertAct(" + act + ")"));
        }
    }

    public void assertIdle(int maxCycles) {
        Condition c = new Condition(){

            public boolean test(TestArch arch) {
                return TestAgent.this.getTS().canSleep();
            }
        };
        if (!this.assertMaxCyclesAndAnotherCondition(c, maxCycles)) {
            Assert.fail((String)"failed assertIdle");
        }
    }

    public void assertPrint(final String out, int maxCycles) {
        Condition c = new Condition(){

            public boolean test(TestArch arch) {
                return arch.getOutput().indexOf(out) >= 0;
            }
        };
        if (this.assertMaxCyclesAndAnotherCondition(c, maxCycles)) {
            this.getArch().clearOutput();
        } else {
            Assert.fail((String)("failed assertPrint(" + out + ")"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean assertMaxCyclesAndAnotherCondition(final Condition c, final int maxCycles) {
        if (maxCycles <= 0) {
            return c.test(this.getArch());
        }
        try {
            Condition mc = new Condition(){

                public boolean test(TestArch arch) {
                    return arch.getCycle() < maxCycles && !c.test(arch);
                }
            };
            this.getArch().start(mc);
            Condition condition = mc;
            synchronized (condition) {
                mc.wait();
            }
            return c.test(this.getArch());
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
    }
}

