/*
 * Decompiled with CFR 0.152.
 */
package jason.asunit;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.asSemantics.ActionExec;
import jason.asSyntax.Literal;
import jason.asunit.Condition;
import jason.environment.Environment;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.CentralisedEnvironment;
import jason.infra.centralised.RunCentralisedMAS;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestArch
extends CentralisedAgArch
implements Runnable {
    private static int nameCount = 0;
    private Condition condition;
    private int cycle = 0;
    private List<Literal> actions = new ArrayList<Literal>();
    StringBuilder output = new StringBuilder();

    public TestArch() {
        this("ASUnitTest" + nameCount++);
    }

    public TestArch(String agName) {
        this.setAgName(agName);
        AgArch a = new AgArch();
        a.setArchInfraTier(this);
        this.setUserAgArch(a);
        RunCentralisedMAS.getRunner().addAg(this);
    }

    public int getCycle() {
        return this.cycle;
    }

    public List<Literal> getActions() {
        return this.actions;
    }

    public void start(Condition c) {
        this.condition = c;
        this.cycle = 0;
        this.actions.clear();
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.condition.test(this)) {
            ++this.cycle;
            this.getUserAgArch().getTS().reasoningCycle();
        }
        Condition condition = this.condition;
        synchronized (condition) {
            this.condition.notifyAll();
        }
    }

    public void setEnv(Environment env) {
        try {
            CentralisedEnvironment infraEnv = new CentralisedEnvironment(null, RunCentralisedMAS.getRunner());
            infraEnv.setUserEnvironment(env);
            env.setEnvironmentInfraTier(infraEnv);
            this.setEnvInfraTier(infraEnv);
        }
        catch (JasonException e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public List<Literal> perceive() {
        if (this.getEnvInfraTier() != null) {
            return super.perceive();
        }
        return null;
    }

    @Override
    public void act(ActionExec action, List<ActionExec> feedback) {
        this.actions.add(action.getActionTerm());
        if (this.getEnvInfraTier() != null) {
            super.act(action, feedback);
        } else {
            action.setResult(true);
            feedback.add(action);
        }
    }

    public void print(String s) {
        System.out.println(s);
        this.output.append(String.valueOf(s) + "\n");
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    public void clearOutput() {
        this.output = new StringBuilder();
    }
}

