/*
 * Decompiled with CFR 0.152.
 */
package jason.environment.grid;

import jason.environment.grid.GridWorldView;
import jason.environment.grid.Location;
import java.util.Random;

public class GridWorldModel {
    public static final int CLEAN = 0;
    public static final int AGENT = 2;
    public static final int OBSTACLE = 4;
    protected int width;
    protected int height;
    protected int[][] data = null;
    protected Location[] agPos;
    protected GridWorldView view;
    protected Random random = new Random();

    protected GridWorldModel(int w, int h, int nbAgs) {
        this.width = w;
        this.height = h;
        this.data = new int[this.width][this.height];
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.height) {
                this.data[i][j] = 0;
                ++j;
            }
            ++i;
        }
        this.agPos = new Location[nbAgs];
        i = 0;
        while (i < this.agPos.length) {
            this.agPos[i] = new Location(-1, -1);
            ++i;
        }
    }

    public void setView(GridWorldView v) {
        this.view = v;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getNbOfAgs() {
        return this.agPos.length;
    }

    public boolean inGrid(Location l) {
        return this.inGrid(l.x, l.y);
    }

    public boolean inGrid(int x, int y) {
        return y >= 0 && y < this.height && x >= 0 && x < this.width;
    }

    public boolean hasObject(int obj, Location l) {
        return this.inGrid(l.x, l.y) && (this.data[l.x][l.y] & obj) != 0;
    }

    public boolean hasObject(int obj, int x, int y) {
        return this.inGrid(x, y) && (this.data[x][y] & obj) != 0;
    }

    public int countObjects(int obj) {
        int c = 0;
        int i = 0;
        while (i < this.width) {
            int j = 0;
            while (j < this.height) {
                if (this.hasObject(obj, i, j)) {
                    ++c;
                }
                ++j;
            }
            ++i;
        }
        return c;
    }

    public void set(int value, int x, int y) {
        this.data[x][y] = value;
        if (this.view != null) {
            this.view.update(x, y);
        }
    }

    public void add(int value, Location l) {
        this.add(value, l.x, l.y);
    }

    public void add(int value, int x, int y) {
        int[] nArray = this.data[x];
        int n = y;
        nArray[n] = nArray[n] | value;
        if (this.view != null) {
            this.view.update(x, y);
        }
    }

    public void addWall(int x1, int y1, int x2, int y2) {
        int x = x1;
        while (x <= x2) {
            int y = y1;
            while (y <= y2) {
                this.add(4, x, y);
                ++y;
            }
            ++x;
        }
    }

    public void remove(int value, Location l) {
        this.remove(value, l.x, l.y);
    }

    public void remove(int value, int x, int y) {
        int[] nArray = this.data[x];
        int n = y;
        nArray[n] = nArray[n] & ~value;
        if (this.view != null) {
            this.view.update(x, y);
        }
    }

    public void setAgPos(int ag, Location l) {
        Location oldLoc = this.getAgPos(ag);
        if (oldLoc != null) {
            this.remove(2, oldLoc.x, oldLoc.y);
        }
        this.agPos[ag] = l;
        this.add(2, l.x, l.y);
    }

    public void setAgPos(int ag, int x, int y) {
        this.setAgPos(ag, new Location(x, y));
    }

    public Location getAgPos(int ag) {
        block3: {
            try {
                if (this.agPos[ag].x != -1) break block3;
                return null;
            }
            catch (Exception e2) {
                return null;
            }
        }
        return (Location)this.agPos[ag].clone();
    }

    public int getAgAtPos(Location l) {
        return this.getAgAtPos(l.x, l.y);
    }

    public int getAgAtPos(int x, int y) {
        int i = 0;
        while (i < this.agPos.length) {
            if (this.agPos[i].x == x && this.agPos[i].y == y) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public boolean isFree(Location l) {
        return this.isFree(l.x, l.y);
    }

    public boolean isFree(int x, int y) {
        return this.inGrid(x, y) && (this.data[x][y] & 4) == 0 && (this.data[x][y] & 2) == 0;
    }

    public boolean isFree(int obj, Location l) {
        return this.inGrid(l.x, l.y) && (this.data[l.x][l.y] & obj) == 0;
    }

    public boolean isFree(int obj, int x, int y) {
        return this.inGrid(x, y) && (this.data[x][y] & obj) == 0;
    }

    public boolean isFreeOfObstacle(Location l) {
        return this.isFree(4, l);
    }

    public boolean isFreeOfObstacle(int x, int y) {
        return this.isFree(4, x, y);
    }

    protected Location getFreePos() {
        int i = 0;
        while (i < this.getWidth() * this.getHeight() * 5) {
            int y;
            int x = this.random.nextInt(this.getWidth());
            Location l = new Location(x, y = this.random.nextInt(this.getHeight()));
            if (this.isFree(l)) {
                return l;
            }
            ++i;
        }
        return null;
    }

    protected Location getFreePos(int obj) {
        int i = 0;
        while (i < this.getWidth() * this.getHeight() * 5) {
            int y;
            int x = this.random.nextInt(this.getWidth());
            Location l = new Location(x, y = this.random.nextInt(this.getHeight()));
            if (this.isFree(obj, l)) {
                return l;
            }
            ++i;
        }
        return null;
    }
}

