/*
 * Decompiled with CFR 0.152.
 */
package jason.environment.grid;

import jason.environment.grid.GridWorldModel;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JFrame;

public class GridWorldView
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected int cellSizeW = 0;
    protected int cellSizeH = 0;
    protected GridCanvas drawArea;
    protected GridWorldModel model;
    protected Font defaultFont = new Font("Arial", 1, 10);
    private static int limit = (int)Math.pow(2.0, 14.0);

    public GridWorldView(GridWorldModel model, String title, int windowSize) {
        super(title);
        this.model = model;
        this.initComponents(windowSize);
        model.setView(this);
    }

    public void initComponents(int width) {
        this.setSize(width, width);
        this.getContentPane().setLayout(new BorderLayout());
        this.drawArea = new GridCanvas();
        this.getContentPane().add("Center", this.drawArea);
    }

    public void repaint() {
        this.cellSizeW = this.drawArea.getWidth() / this.model.getWidth();
        this.cellSizeH = this.drawArea.getHeight() / this.model.getHeight();
        super.repaint();
        this.drawArea.repaint();
    }

    public void update() {
        this.repaint();
    }

    public void update(int x, int y) {
        Graphics g = this.drawArea.getGraphics();
        if (g == null) {
            return;
        }
        this.drawEmpty(g, x, y);
        this.draw(g, x, y);
    }

    public void drawObstacle(Graphics g, int x, int y) {
        g.setColor(Color.darkGray);
        g.fillRect(x * this.cellSizeW + 1, y * this.cellSizeH + 1, this.cellSizeW - 1, this.cellSizeH - 1);
        g.setColor(Color.black);
        g.drawRect(x * this.cellSizeW + 2, y * this.cellSizeH + 2, this.cellSizeW - 4, this.cellSizeH - 4);
    }

    public void drawAgent(Graphics g, int x, int y, Color c, int id) {
        g.setColor(c);
        g.fillOval(x * this.cellSizeW + 2, y * this.cellSizeH + 2, this.cellSizeW - 4, this.cellSizeH - 4);
        if (id >= 0) {
            g.setColor(Color.black);
            this.drawString(g, x, y, this.defaultFont, String.valueOf(id + 1));
        }
    }

    public void drawString(Graphics g, int x, int y, Font f, String s) {
        g.setFont(f);
        FontMetrics metrics = g.getFontMetrics();
        int width = metrics.stringWidth(s);
        int height = metrics.getHeight();
        g.drawString(s, x * this.cellSizeW + (this.cellSizeW / 2 - width / 2), y * this.cellSizeH + (this.cellSizeH / 2 + height / 2));
    }

    public void drawEmpty(Graphics g, int x, int y) {
        g.setColor(Color.white);
        g.fillRect(x * this.cellSizeW + 1, y * this.cellSizeH + 1, this.cellSizeW - 1, this.cellSizeH - 1);
        g.setColor(Color.lightGray);
        g.drawRect(x * this.cellSizeW, y * this.cellSizeH, this.cellSizeW, this.cellSizeH);
    }

    public void draw(Graphics g, int x, int y, int object) {
    }

    private void draw(Graphics g, int x, int y) {
        if ((this.model.data[x][y] & 4) != 0) {
            this.drawObstacle(g, x, y);
        }
        int vl = 8;
        while (vl < limit) {
            if ((this.model.data[x][y] & vl) != 0) {
                this.draw(g, x, y, vl);
            }
            vl *= 2;
        }
        if ((this.model.data[x][y] & 2) != 0) {
            this.drawAgent(this.drawArea.getGraphics(), x, y, Color.blue, this.model.getAgAtPos(x, y));
        }
    }

    public Canvas getCanvas() {
        return this.drawArea;
    }

    public GridWorldModel getModel() {
        return this.model;
    }

    class GridCanvas
    extends Canvas {
        private static final long serialVersionUID = 1L;

        GridCanvas() {
        }

        public void paint(Graphics g) {
            GridWorldView.this.cellSizeW = GridWorldView.this.drawArea.getWidth() / GridWorldView.this.model.getWidth();
            GridWorldView.this.cellSizeH = GridWorldView.this.drawArea.getHeight() / GridWorldView.this.model.getHeight();
            int mwidth = GridWorldView.this.model.getWidth();
            int mheight = GridWorldView.this.model.getHeight();
            g.setColor(Color.lightGray);
            int l = 1;
            while (l <= mheight) {
                g.drawLine(0, l * GridWorldView.this.cellSizeH, mwidth * GridWorldView.this.cellSizeW, l * GridWorldView.this.cellSizeH);
                ++l;
            }
            int c = 1;
            while (c <= mwidth) {
                g.drawLine(c * GridWorldView.this.cellSizeW, 0, c * GridWorldView.this.cellSizeW, mheight * GridWorldView.this.cellSizeH);
                ++c;
            }
            int x = 0;
            while (x < mwidth) {
                int y = 0;
                while (y < mheight) {
                    GridWorldView.this.draw(g, x, y);
                    ++y;
                }
                ++x;
            }
        }
    }
}

