/*
 * Decompiled with CFR 0.152.
 */
package jason.environment.grid;

public final class Location {
    public int x;
    public int y;

    public Location(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int distance(Location l) {
        return Math.abs(this.x - l.x) + Math.abs(this.y - l.y);
    }

    public double distanceEuclidean(Location l) {
        return Math.sqrt(Math.pow(this.x - l.x, 2.0) + Math.pow(this.y - l.y, 2.0));
    }

    public int maxBorder(Location l) {
        return Math.max(Math.abs(this.x - l.x), Math.abs(this.y - l.y));
    }

    public boolean isInArea(Location tr, Location bl) {
        return this.x >= tr.x && this.x <= bl.x && this.y >= tr.y && this.y <= bl.y;
    }

    public boolean isNeigbour(Location l) {
        return this.distance(l) == 1 || this.equals(l) || Math.abs(this.x - l.x) == 1 && Math.abs(this.y - l.y) == 1;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Location other = (Location)obj;
        if (this.x != other.x) {
            return false;
        }
        return this.y == other.y;
    }

    public Object clone() {
        return new Location(this.x, this.y);
    }

    public String toString() {
        return String.valueOf(this.x) + "," + this.y;
    }
}

