/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class BaseDialogGUI
extends JDialog {
    protected JButton ok;
    protected JButton cancel;
    protected JPanel pFields = new JPanel(new GridLayout(0, 1));
    protected JPanel pLabels = new JPanel(new GridLayout(0, 1));

    public BaseDialogGUI(Frame f, String title) {
        super(f);
        this.setTitle(title);
        this.initComponents();
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((screenSize.width - this.getWidth()) / 2, (screenSize.height - this.getHeight()) / 2);
        this.setVisible(true);
    }

    protected abstract void initComponents();

    protected JPanel createButtonsPanel() {
        JPanel bts = new JPanel(new FlowLayout(1));
        this.ok = new JButton("Ok");
        this.ok.setDefaultCapable(true);
        this.ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                if (BaseDialogGUI.this.ok()) {
                    BaseDialogGUI.this.setVisible(false);
                }
            }
        });
        bts.add(this.ok);
        this.cancel = new JButton("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                BaseDialogGUI.this.setVisible(false);
            }
        });
        bts.add(this.cancel);
        this.getRootPane().setDefaultButton(this.ok);
        return bts;
    }

    protected void createField(String label, JComponent tf, String tooltip) {
        JLabel jl = new JLabel(String.valueOf(label) + ": ");
        jl.setToolTipText(tooltip);
        tf.setToolTipText(tooltip);
        this.pLabels.add(jl);
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(tf);
        this.pFields.add(p);
    }

    protected void createField(String label, JComponent tf1, JComponent tf2, String tooltip) {
        JLabel jl = new JLabel(String.valueOf(label) + ": ");
        jl.setToolTipText(tooltip);
        tf1.setToolTipText(tooltip);
        this.pLabels.add(jl);
        JPanel p = new JPanel(new FlowLayout(0));
        p.add(tf1);
        p.add(tf2);
        this.pFields.add(p);
    }

    protected abstract boolean ok();
}

