/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.ReceiverNotFoundException;
import jason.architecture.AgArch;
import jason.architecture.AgArchInfraTier;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Agent;
import jason.asSemantics.Message;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.Literal;
import jason.infra.centralised.CentralisedEnvironment;
import jason.infra.centralised.CentralisedExecutionControl;
import jason.infra.centralised.CentralisedRuntimeServices;
import jason.infra.centralised.MsgListener;
import jason.infra.centralised.RunCentralisedMAS;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentralisedAgArch
implements Runnable,
AgArchInfraTier {
    protected CentralisedEnvironment infraEnv = null;
    private CentralisedExecutionControl infraControl = null;
    private RunCentralisedMAS masRunner = RunCentralisedMAS.getRunner();
    protected AgArch userAgArch;
    private String agName = "";
    private boolean running = true;
    private Queue<Message> mbox = new ConcurrentLinkedQueue<Message>();
    protected Logger logger = Logger.getLogger(CentralisedAgArch.class.getName());
    private static List<MsgListener> msgListeners = null;
    private Object syncStopRun = new Object();
    private Thread myThread = null;
    private Object sleepSync = new Object();
    private Object syncMonitor = new Object();
    private boolean inWaitSyncMonitor = false;

    public static void addMsgListener(MsgListener l) {
        if (msgListeners == null) {
            msgListeners = new ArrayList<MsgListener>();
        }
        msgListeners.add(l);
    }

    public static void removeMsgListener(MsgListener l) {
        msgListeners.remove(l);
    }

    public void initAg(String agArchClass, String agClass, ClassParameters bbPars, String asSrc, Settings stts, RunCentralisedMAS masRunner) throws JasonException {
        try {
            this.masRunner = masRunner;
            this.userAgArch = (AgArch)Class.forName(agArchClass).newInstance();
            this.userAgArch.setArchInfraTier(this);
            this.userAgArch.initAg(agClass, bbPars, asSrc, stts);
            this.setLogger();
        }
        catch (Exception e2) {
            this.running = false;
            throw new JasonException("as2j: error creating the agent class! - " + e2.getMessage(), e2);
        }
    }

    void initAg(String agArchClass, Agent ag, RunCentralisedMAS masRunner) throws JasonException {
        try {
            this.masRunner = masRunner;
            this.userAgArch = (AgArch)Class.forName(agArchClass).newInstance();
            this.userAgArch.setArchInfraTier(this);
            Agent agClone = ag.clone(this.userAgArch);
            this.userAgArch.setTS(agClone.getTS());
            this.setLogger();
        }
        catch (Exception e2) {
            this.running = false;
            throw new JasonException("as2j: error creating the agent class! - ", e2);
        }
    }

    public void setLogger() {
        this.logger = Logger.getLogger(String.valueOf(CentralisedAgArch.class.getName()) + "." + this.getAgName());
        this.logger.setLevel(this.userAgArch.getTS().getSettings().logLevel());
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setAgName(String name) {
        this.agName = name;
    }

    @Override
    public String getAgName() {
        return this.agName;
    }

    public void setUserAgArch(AgArch arch) {
        this.userAgArch = arch;
    }

    public AgArch getUserAgArch() {
        return this.userAgArch;
    }

    public void setEnvInfraTier(CentralisedEnvironment env) {
        this.infraEnv = env;
    }

    public CentralisedEnvironment getEnvInfraTier() {
        return this.infraEnv;
    }

    public void setControlInfraTier(CentralisedExecutionControl pControl) {
        this.infraControl = pControl;
    }

    public CentralisedExecutionControl getControlInfraTier() {
        return this.infraControl;
    }

    protected void setThread(Thread t) {
        this.myThread = t;
        this.myThread.setName(this.agName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopAg() {
        this.running = false;
        if (this.myThread != null) {
            this.myThread.interrupt();
        }
        Object object = this.syncStopRun;
        synchronized (object) {
            this.masRunner.delAg(this.agName);
        }
        this.userAgArch.stopAg();
    }

    @Override
    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object = this.syncStopRun;
        synchronized (object) {
            TransitionSystem ts = this.userAgArch.getTS();
            while (this.running) {
                if (ts.getSettings().isSync()) {
                    this.waitSyncSignal();
                    ts.reasoningCycle();
                    boolean isBreakPoint = false;
                    try {
                        isBreakPoint = ts.getC().getSelectedOption().getPlan().hasBreakpoint();
                        if (this.logger.isLoggable(Level.FINE)) {
                            this.logger.fine("Informing controller that I finished a reasoning cycle " + this.userAgArch.getCycleNumber() + ". Breakpoint is " + isBreakPoint);
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    this.informCycleFinished(isBreakPoint, this.userAgArch.getCycleNumber());
                    continue;
                }
                ts.reasoningCycle();
            }
        }
        this.logger.info("I finished!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sleep() {
        block6: {
            try {
                if (this.userAgArch.getTS().getSettings().isSync()) break block6;
                this.logger.fine("Entering in sleep mode....");
                Object object = this.sleepSync;
                synchronized (object) {
                    this.sleepSync.wait(500L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception e2) {
                this.logger.log(Level.WARNING, "Error in sleep.", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wake() {
        Object object = this.sleepSync;
        synchronized (object) {
            this.sleepSync.notifyAll();
        }
    }

    @Override
    public List<Literal> perceive() {
        List<Literal> percepts = this.infraEnv.getUserEnvironment().getPercepts(this.getAgName());
        if (this.logger.isLoggable(Level.FINE) && percepts != null) {
            this.logger.fine("percepts: " + percepts);
        }
        return percepts;
    }

    @Override
    public void sendMsg(Message m) throws ReceiverNotFoundException {
        CentralisedAgArch rec;
        if (m.getSender() == null) {
            m.setSender(this.getAgName());
        }
        if ((rec = this.masRunner.getAg(m.getReceiver())) == null) {
            if (this.isRunning()) {
                throw new ReceiverNotFoundException("Receiver '" + m.getReceiver() + "' does not exists! Could not send " + m);
            }
            return;
        }
        rec.receiveMsg(m.clone());
        if (msgListeners != null) {
            for (MsgListener l : msgListeners) {
                l.msgSent(m);
            }
        }
    }

    public void receiveMsg(Message m) {
        this.mbox.offer(m);
        this.wake();
    }

    @Override
    public void broadcast(Message m) throws Exception {
        for (String agName : this.masRunner.getAgs().keySet()) {
            if (agName.equals(this.getAgName())) continue;
            m.setReceiver(agName);
            this.sendMsg(m);
        }
    }

    @Override
    public void checkMail() {
        Queue<Message> tsmb = this.userAgArch.getTS().getC().getMailBox();
        while (!this.mbox.isEmpty()) {
            Message im = this.mbox.poll();
            tsmb.offer(im);
            if (!this.logger.isLoggable(Level.FINE)) continue;
            this.logger.fine("received message: " + im);
        }
    }

    @Override
    public void act(ActionExec action, List<ActionExec> feedback) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.info("doing: " + action.getActionTerm());
        }
        if (this.isRunning()) {
            this.infraEnv.act(this.getAgName(), action);
        }
    }

    public void actionExecuted(ActionExec action) {
        this.userAgArch.getTS().getC().addFeedbackAction(action);
        this.wake();
    }

    @Override
    public boolean canSleep() {
        return this.mbox.isEmpty() && this.isRunning();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitSyncSignal() {
        try {
            Object object = this.syncMonitor;
            synchronized (object) {
                this.inWaitSyncMonitor = true;
                this.syncMonitor.wait();
                this.inWaitSyncMonitor = false;
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e2) {
            this.logger.log(Level.WARNING, "Error waiting sync (1)", e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveSyncSignal() {
        try {
            Object object = this.syncMonitor;
            synchronized (object) {
                while (!this.inWaitSyncMonitor && this.isRunning()) {
                    this.syncMonitor.wait(50L);
                }
                this.syncMonitor.notifyAll();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        catch (Exception e2) {
            this.logger.log(Level.WARNING, "Error waiting sync (2)", e2);
        }
    }

    public void informCycleFinished(boolean breakpoint, int cycle) {
        this.infraControl.receiveFinishedCycle(this.getAgName(), breakpoint, cycle);
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new CentralisedRuntimeServices(this.masRunner);
    }
}

