/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.control.ExecutionControl;
import jason.control.ExecutionControlInfraTier;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.CentralisedRuntimeServices;
import jason.infra.centralised.RunCentralisedMAS;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class CentralisedExecutionControl
implements ExecutionControlInfraTier {
    private ExecutionControl userController;
    private RunCentralisedMAS masRunner = null;
    private static Logger logger = Logger.getLogger(CentralisedExecutionControl.class.getName());

    public CentralisedExecutionControl(ClassParameters userControlClass, RunCentralisedMAS masRunner) throws JasonException {
        this.masRunner = masRunner;
        try {
            this.userController = (ExecutionControl)Class.forName(userControlClass.getClassName()).newInstance();
            this.userController.setExecutionControlInfraTier(this);
            this.userController.init(userControlClass.getParametersArray());
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error ", e2);
            throw new JasonException("The user execution control class instantiation '" + userControlClass + "' has failed!" + e2.getMessage());
        }
    }

    public void stop() {
        this.userController.stop();
    }

    public ExecutionControl getUserControl() {
        return this.userController;
    }

    public void receiveFinishedCycle(String agName, boolean breakpoint, int cycle) {
        this.userController.receiveFinishedCycle(agName, breakpoint, cycle);
    }

    public void informAgToPerformCycle(String agName, int cycle) {
        CentralisedAgArch infraArch = this.masRunner.getAg(agName);
        AgArch arch = infraArch.getUserAgArch();
        arch.setCycleNumber(cycle);
        infraArch.receiveSyncSignal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void informAllAgsToPerformCycle(int cycle) {
        Map<String, CentralisedAgArch> map = this.masRunner.getAgs();
        synchronized (map) {
            for (CentralisedAgArch ag : this.masRunner.getAgs().values()) {
                ag.getUserAgArch().setCycleNumber(cycle);
                ag.receiveSyncSignal();
            }
        }
    }

    public Document getAgState(String agName) {
        AgArch arch = this.masRunner.getAg(agName).getUserAgArch();
        if (arch != null) {
            return arch.getTS().getAg().getAgState();
        }
        return null;
    }

    public RuntimeServicesInfraTier getRuntimeServices() {
        return new CentralisedRuntimeServices(this.masRunner);
    }
}

