/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.centralised;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.asSemantics.Agent;
import jason.infra.centralised.CentralisedAgArch;
import jason.infra.centralised.RunCentralisedMAS;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CentralisedRuntimeServices
implements RuntimeServicesInfraTier {
    private static Logger logger = Logger.getLogger(CentralisedRuntimeServices.class.getName());
    private RunCentralisedMAS masRunner;

    public CentralisedRuntimeServices(RunCentralisedMAS masRunner) {
        this.masRunner = masRunner;
    }

    @Override
    public boolean createAgent(String agName, String agSource, String agClass, String archClass, ClassParameters bbPars, Settings stts) throws Exception {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("Creating centralised agent " + agName + "from source " + agSource + "(agClass=" + agClass + ", archClass=" + archClass + ", settings=" + stts);
        }
        AgentParameters ap = new AgentParameters();
        ap.setAgClass(agClass);
        ap.setArchClass(archClass);
        ap.setBB(bbPars);
        ap.setupDefault();
        if (stts == null) {
            stts = new Settings();
        }
        while (this.masRunner.getAg(agName) != null) {
            agName = String.valueOf(agName) + "_a";
        }
        CentralisedAgArch agArch = new CentralisedAgArch();
        agArch.setAgName(agName);
        agArch.initAg(ap.archClass.getClassName(), ap.agClass.getClassName(), ap.getBBClass(), agSource, stts, this.masRunner);
        agArch.setEnvInfraTier(this.masRunner.getEnvironmentInfraTier());
        agArch.setControlInfraTier(this.masRunner.getControllerInfraTier());
        this.masRunner.addAg(agArch);
        Thread agThread = new Thread(agArch);
        agArch.setThread(agThread);
        agThread.start();
        logger.fine("Agent " + agName + " created!");
        return true;
    }

    @Override
    public AgArch clone(Agent source, String archClassName, String agName) throws JasonException {
        CentralisedAgArch agArch = new CentralisedAgArch();
        agArch.setAgName(agName);
        agArch.setEnvInfraTier(this.masRunner.getEnvironmentInfraTier());
        agArch.setControlInfraTier(this.masRunner.getControllerInfraTier());
        this.masRunner.addAg(agArch);
        agArch.initAg(archClassName, source, this.masRunner);
        Thread agThread = new Thread(agArch);
        agArch.setThread(agThread);
        agThread.start();
        return agArch.getUserAgArch();
    }

    @Override
    public Set<String> getAgentsNames() {
        return this.masRunner.getAgs().keySet();
    }

    @Override
    public Set<String> getAgentsName() {
        return this.getAgentsNames();
    }

    @Override
    public int getAgentsQty() {
        return this.masRunner.getAgs().keySet().size();
    }

    @Override
    public boolean killAgent(String agName) {
        logger.fine("Killing centralised agent " + agName);
        CentralisedAgArch ag = this.masRunner.getAg(agName);
        if (ag != null) {
            ag.stopAg();
            return true;
        }
        return false;
    }

    @Override
    public void stopMAS() throws Exception {
        this.masRunner.finish();
    }
}

