/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.OneShotBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jason.asSemantics.Message;
import jason.asSyntax.Term;
import jason.infra.jade.JadeAgArch;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class JadeAg
extends Agent {
    public static final int UNTELL = 1001;
    public static final int ASKALL = 1002;
    public static final int UNACHIEVE = 1003;
    public static final int TELLHOW = 1004;
    public static final int UNTELLHOW = 1005;
    public static final int ASKHOW = 1006;
    private static final long serialVersionUID = 1L;
    protected Logger logger = Logger.getLogger(JadeAg.class.getName());
    protected static int rwid = 0;
    protected boolean running = true;
    protected Map<String, String> conversationIds = new HashMap<String, String>();

    public void doDelete() {
        this.running = false;
        super.doDelete();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void sendMsg(Message m) throws Exception {
        String convid;
        ACLMessage acl = this.jasonToACL(m);
        acl.addReceiver(new AID(m.getReceiver(), false));
        if (m.getInReplyTo() != null && (convid = this.conversationIds.get(m.getInReplyTo())) != null) {
            acl.setConversationId(convid);
        }
        this.send(acl);
    }

    public void broadcast(final Message m) {
        this.addBehaviour((Behaviour)new OneShotBehaviour(){
            private static final long serialVersionUID = 1L;

            public void action() {
                try {
                    ACLMessage acl = JadeAg.this.jasonToACL(m);
                    JadeAg.this.addAllAgsAsReceivers(acl);
                    JadeAg.this.send(acl);
                }
                catch (Exception e2) {
                    JadeAg.this.logger.log(Level.SEVERE, "Error in broadcast of " + m, e2);
                }
            }
        });
    }

    protected ACLMessage ask(ACLMessage m) {
        try {
            String waitingRW = "id" + ++rwid;
            m.setReplyWith(waitingRW);
            this.send(m);
            ACLMessage r = this.blockingReceive(MessageTemplate.MatchInReplyTo((String)waitingRW), 5000L);
            if (r != null) {
                return r;
            }
            this.logger.warning("ask timeout for " + m.getContent());
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error waiting message.", e2);
        }
        return null;
    }

    public void addAllAgsAsReceivers(ACLMessage m) throws Exception {
        DFAgentDescription template = new DFAgentDescription();
        ServiceDescription sd = new ServiceDescription();
        sd.setType("jason");
        sd.setName(JadeAgArch.dfName);
        template.addServices(sd);
        DFAgentDescription[] ans = DFService.search((Agent)this, (DFAgentDescription)template);
        int i = 0;
        while (i < ans.length) {
            if (!ans[i].getName().equals((Object)this.getAID())) {
                m.addReceiver(ans[i].getName());
            }
            ++i;
        }
    }

    protected ACLMessage jasonToACL(Message m) throws IOException {
        ACLMessage acl = new ACLMessage(JadeAg.kqmlToACL(m.getIlForce()));
        if (m.getPropCont() instanceof Term || m.getPropCont() instanceof String) {
            acl.setContent(m.getPropCont().toString());
        } else {
            acl.setContentObject((Serializable)m.getPropCont());
        }
        acl.setReplyWith(m.getMsgId());
        acl.setLanguage("AgentSpeak");
        if (m.getInReplyTo() != null) {
            acl.setInReplyTo(m.getInReplyTo());
        }
        return acl;
    }

    public static int kqmlToACL(String p) {
        if (p.equals("tell")) {
            return 7;
        }
        if (p.equals("askOne")) {
            return 13;
        }
        if (p.equals("achieve")) {
            return 16;
        }
        if (p.equals("untell")) {
            return 1001;
        }
        if (p.equals("unachieve")) {
            return 1003;
        }
        if (p.equals("askAll")) {
            return 1002;
        }
        if (p.equals("askHow")) {
            return 1006;
        }
        if (p.equals("tellHow")) {
            return 1004;
        }
        if (p.equals("untellHow")) {
            return 1005;
        }
        return ACLMessage.getInteger((String)p);
    }

    public static String aclToKqml(int p) {
        switch (p) {
            case 7: {
                return "tell";
            }
            case 13: {
                return "askOne";
            }
            case 16: {
                return "achieve";
            }
            case 1001: {
                return "untell";
            }
            case 1003: {
                return "unachieve";
            }
            case 1002: {
                return "askAll";
            }
            case 1006: {
                return "askHow";
            }
            case 1004: {
                return "tellHow";
            }
            case 1005: {
                return "untellHow";
            }
        }
        return ACLMessage.getPerformative((int)p).toLowerCase().replaceAll("-", "_");
    }
}

