/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.lang.acl.UnreadableException;
import jade.wrapper.ContainerController;
import jason.architecture.AgArch;
import jason.architecture.AgArchInfraTier;
import jason.asSemantics.ActionExec;
import jason.asSemantics.Message;
import jason.asSemantics.TransitionSystem;
import jason.asSyntax.ListTerm;
import jason.asSyntax.ListTermImpl;
import jason.asSyntax.Literal;
import jason.asSyntax.StringTermImpl;
import jason.asSyntax.Structure;
import jason.bb.DefaultBeliefBase;
import jason.infra.centralised.RunCentralisedMAS;
import jason.infra.jade.JadeAg;
import jason.infra.jade.JadeEnvironment;
import jason.infra.jade.JadeExecutionControl;
import jason.infra.jade.JadeRuntimeServices;
import jason.infra.jade.RunJadeMAS;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadeAgArch
extends JadeAg
implements AgArchInfraTier {
    public static String dfName = "j_agent";
    private static final long serialVersionUID = 1L;
    protected AgArch userAgArch;
    private Map<String, ActionExec> myPA = new HashMap<String, ActionExec>();
    private boolean enterInSleepMode = false;
    AID controllerAID = new AID(RunJadeMAS.controllerName, false);
    AID environmentAID = null;
    Behaviour tsBehaviour;
    private MessageTemplate ts = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchContent((String)"agState"), (MessageTemplate)MessageTemplate.MatchOntology((String)JadeExecutionControl.controllerOntology));
    private MessageTemplate tc = MessageTemplate.and((MessageTemplate)MessageTemplate.MatchContent((String)"performCycle"), (MessageTemplate)MessageTemplate.MatchOntology((String)JadeExecutionControl.controllerOntology));

    protected void setup() {
        RunCentralisedMAS.setupLogger();
        this.logger = Logger.getLogger(String.valueOf(JadeAgArch.class.getName()) + "." + this.getAgName());
        this.logger.info("starting " + this.getLocalName());
        try {
            String asSource = null;
            String archClassName = null;
            String agClassName = null;
            ClassParameters bbPars = null;
            Settings stts = null;
            Object[] args = this.getArguments();
            if (args == null) {
                this.logger.info("No AgentSpeak source informed!");
                return;
            }
            if (args[0] instanceof AgentParameters) {
                AgentParameters ap = (AgentParameters)args[0];
                asSource = ap.asSource.getAbsolutePath();
                archClassName = ap.archClass.getClassName();
                agClassName = ap.agClass.getClassName();
                bbPars = ap.getBBClass();
                stts = ap.getAsSetts((Boolean)args[1], (Boolean)args[2]);
            } else {
                asSource = args[0].toString();
                archClassName = AgArch.class.getName();
                agClassName = jason.asSemantics.Agent.class.getName();
                bbPars = new ClassParameters(DefaultBeliefBase.class.getName());
                stts = new Settings();
                int i = 1;
                while (i < args.length) {
                    if (args[i].toString().equals("arch")) {
                        archClassName = args[++i].toString();
                    } else if (args[i].toString().equals("ag")) {
                        agClassName = args[++i].toString();
                    }
                    ++i;
                }
            }
            this.userAgArch = (AgArch)Class.forName(archClassName).newInstance();
            this.userAgArch.setArchInfraTier(this);
            this.userAgArch.initAg(agClassName, bbPars, asSource, stts);
            this.logger.setLevel(this.userAgArch.getTS().getSettings().logLevel());
            DFAgentDescription dfa = new DFAgentDescription();
            dfa.setName(this.getAID());
            ServiceDescription vc = new ServiceDescription();
            vc.setType("jason");
            vc.setName(dfName);
            dfa.addServices(vc);
            try {
                DFService.register((Agent)this, (DFAgentDescription)dfa);
            }
            catch (FIPAException e2) {
                this.logger.log(Level.SEVERE, "Error registering agent in DF", e2);
            }
            this.tsBehaviour = new CyclicBehaviour(){
                TransitionSystem ts;
                {
                    this.ts = JadeAgArch.this.userAgArch.getTS();
                }

                public void action() {
                    if (this.ts.getSettings().isSync()) {
                        if (JadeAgArch.this.processExecutionControlOntologyMsg()) {
                            this.ts.reasoningCycle();
                            boolean isBreakPoint = false;
                            try {
                                isBreakPoint = this.ts.getC().getSelectedOption().getPlan().hasBreakpoint();
                                if (JadeAgArch.this.logger.isLoggable(Level.FINE)) {
                                    JadeAgArch.this.logger.fine("Informing controller that I finished a reasoning cycle " + JadeAgArch.this.userAgArch.getCycleNumber() + ". Breakpoint is " + isBreakPoint);
                                }
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                            JadeAgArch.this.informCycleFinished(isBreakPoint, JadeAgArch.this.userAgArch.getCycleNumber());
                        } else {
                            this.block(1000L);
                        }
                    } else if (JadeAgArch.this.enterInSleepMode) {
                        this.block(1000L);
                        JadeAgArch.this.enterInSleepMode = false;
                    } else {
                        this.ts.reasoningCycle();
                    }
                }
            };
            this.addBehaviour(this.tsBehaviour);
            this.logger.fine("Created from source " + asSource);
        }
        catch (Exception e3) {
            this.logger.log(Level.SEVERE, "Error creating JADE architecture.", e3);
        }
    }

    @Override
    public void doDelete() {
        try {
            try {
                this.running = false;
                if (this.userAgArch != null) {
                    this.userAgArch.stopAg();
                }
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error in doDelete.", e2);
                super.doDelete();
            }
        }
        finally {
            super.doDelete();
        }
    }

    protected void takeDown() {
        this.logger.info("Finished!");
    }

    @Override
    public void stopAg() {
        this.doDelete();
    }

    @Override
    public void sleep() {
        this.enterInSleepMode = true;
    }

    @Override
    public void wake() {
        this.tsBehaviour.restart();
    }

    @Override
    public String getAgName() {
        return this.getLocalName();
    }

    @Override
    public boolean canSleep() {
        return this.getCurQueueSize() == 0 && this.isRunning();
    }

    @Override
    public void checkMail() {
        ACLMessage m = null;
        do {
            try {
                m = this.receive();
                if (m == null) continue;
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Received message: " + m);
                }
                if (this.isActionFeedback(m)) continue;
                String ilForce = JadeAgArch.aclToKqml(m.getPerformative());
                String sender = m.getSender().getLocalName();
                String replyWith = m.getReplyWith();
                if (replyWith == null || replyWith.length() == 0) {
                    replyWith = "noid";
                }
                String irt = m.getInReplyTo();
                Object propCont = null;
                try {
                    propCont = m.getContentObject();
                }
                catch (UnreadableException e2) {
                    if (m.getLanguage() == null || !m.getLanguage().equals("AgentSpeak")) {
                        propCont = new StringTermImpl(m.getContent());
                        if (!replyWith.equals("noid") && m.getConversationId() != null) {
                            this.conversationIds.put(replyWith, m.getConversationId());
                        }
                    }
                    propCont = m.getContent();
                }
                if (propCont == null) continue;
                Message im = new Message(ilForce, sender, this.getLocalName(), propCont, replyWith);
                if (irt != null) {
                    im.setInReplyTo(irt);
                }
                this.userAgArch.getTS().getC().getMailBox().add(im);
            }
            catch (Exception e3) {
                this.logger.log(Level.SEVERE, "Error receiving message.", e3);
            }
        } while (m != null);
    }

    boolean isActionFeedback(ACLMessage m) {
        if (m.getOntology() != null && m.getOntology().equals(JadeEnvironment.actionOntology)) {
            String irt = m.getInReplyTo();
            if (irt != null) {
                ActionExec a = this.myPA.remove(irt);
                if (a != null) {
                    if (m.getContent().equals("ok")) {
                        a.setResult(true);
                    } else {
                        a.setResult(false);
                    }
                    this.userAgArch.getTS().getC().addFeedbackAction(a);
                } else {
                    this.logger.log(Level.SEVERE, "Error: received feedback for an Action that is not pending. The message is " + m);
                }
            }
            return true;
        }
        return false;
    }

    boolean processExecutionControlOntologyMsg() {
        ACLMessage m = this.receive(this.ts);
        if (m != null) {
            ACLMessage r = m.createReply();
            r.setPerformative(7);
            try {
                Document agStateDoc = this.userAgArch.getTS().getAg().getAgState();
                r.setContentObject((Serializable)((Object)agStateDoc));
                this.send(r);
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error sending message " + r, e2);
            }
        }
        if ((m = this.receive(this.tc)) != null) {
            int cycle = Integer.parseInt(m.getUserDefinedParameter("cycle"));
            this.logger.fine("new cycle: " + cycle);
            this.userAgArch.setCycleNumber(cycle);
            return true;
        }
        return false;
    }

    boolean isPerceptionOntology(ACLMessage m) {
        return m.getOntology() != null && m.getOntology().equals(JadeEnvironment.perceptionOntology);
    }

    @Override
    public List<Literal> perceive() {
        if (!this.isRunning()) {
            return null;
        }
        if (this.getEnvironmentAg() == null) {
            return null;
        }
        ListTerm percepts = null;
        try {
            ACLMessage askMsg = new ACLMessage(13);
            askMsg.addReceiver(this.environmentAID);
            askMsg.setOntology(JadeEnvironment.perceptionOntology);
            askMsg.setContent("getPercepts");
            ACLMessage r = this.ask(askMsg);
            if (r != null && r.getContent().startsWith("[")) {
                percepts = ListTermImpl.parseList(r.getContent());
            }
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error in perceive.", e2);
        }
        return percepts;
    }

    private AID getEnvironmentAg() {
        if (this.environmentAID == null) {
            DFAgentDescription template = new DFAgentDescription();
            ServiceDescription sd = new ServiceDescription();
            sd.setType("jason");
            sd.setName(RunJadeMAS.environmentName);
            template.addServices(sd);
            try {
                DFAgentDescription[] ans = DFService.search((Agent)this, (DFAgentDescription)template);
                if (ans.length > 0) {
                    this.environmentAID = ans[0].getName();
                    return this.environmentAID;
                }
            }
            catch (Exception e2) {
                this.logger.log(Level.SEVERE, "Error getting environment from DF.", e2);
            }
        }
        return this.environmentAID;
    }

    @Override
    public void act(ActionExec action, List<ActionExec> feedback) {
        if (!this.isRunning()) {
            return;
        }
        if (this.getEnvironmentAg() == null) {
            return;
        }
        try {
            Structure acTerm = action.getActionTerm();
            this.logger.fine("doing: " + acTerm);
            String rw = "id" + ++rwid;
            ACLMessage m = new ACLMessage(16);
            m.addReceiver(this.environmentAID);
            m.setOntology(JadeEnvironment.actionOntology);
            m.setContent(((Object)acTerm).toString());
            m.setReplyWith(rw);
            this.myPA.put(rw, action);
            this.send(m);
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error sending action " + action, e2);
        }
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new JadeRuntimeServices((ContainerController)this.getContainerController(), this);
    }

    public void informCycleFinished(boolean breakpoint, int cycle) {
        try {
            ACLMessage m = new ACLMessage(7);
            m.addReceiver(this.controllerAID);
            m.setOntology(JadeExecutionControl.controllerOntology);
            m.setContent(String.valueOf(breakpoint) + "," + cycle);
            this.send(m);
        }
        catch (Exception e2) {
            this.logger.log(Level.SEVERE, "Error sending cycle finished.", e2);
        }
    }
}

