/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.core.AID;
import jade.core.Agent;
import jade.core.behaviours.Behaviour;
import jade.core.behaviours.CyclicBehaviour;
import jade.domain.DFService;
import jade.domain.FIPAAgentManagement.DFAgentDescription;
import jade.domain.FIPAAgentManagement.ServiceDescription;
import jade.domain.FIPAException;
import jade.lang.acl.ACLMessage;
import jade.wrapper.ContainerController;
import jason.asSemantics.Message;
import jason.asSyntax.Literal;
import jason.asSyntax.Structure;
import jason.environment.Environment;
import jason.environment.EnvironmentInfraTier;
import jason.infra.jade.JadeAg;
import jason.infra.jade.JadeRuntimeServices;
import jason.infra.jade.RunJadeMAS;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JadeEnvironment
extends JadeAg
implements EnvironmentInfraTier {
    private static Logger logger = Logger.getLogger(JadeEnvironment.class.getName());
    public static String actionOntology = "AS-actions";
    public static String perceptionOntology = "AS-perception";
    private Environment userEnv;

    public void setup() {
        try {
            Object[] args = this.getArguments();
            if (args != null && args.length > 0) {
                if (args[0] instanceof ClassParameters) {
                    ClassParameters ep = (ClassParameters)args[0];
                    this.userEnv = (Environment)Class.forName(ep.getClassName()).newInstance();
                    this.userEnv.setEnvironmentInfraTier(this);
                    this.userEnv.init(ep.getParametersArray());
                } else {
                    this.userEnv = (Environment)Class.forName(args[0].toString()).newInstance();
                    this.userEnv.setEnvironmentInfraTier(this);
                    if (args.length > 1) {
                        logger.warning("Environment arguments is not implemented yet (ask it to us if you need)!");
                    }
                }
            } else {
                logger.warning("Using default environment.");
                this.userEnv = new Environment();
                this.userEnv.setEnvironmentInfraTier(this);
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error in setup Jade Environment", e2);
        }
        DFAgentDescription dfa = new DFAgentDescription();
        dfa.setName(this.getAID());
        ServiceDescription vc = new ServiceDescription();
        vc.setType("jason");
        vc.setName(RunJadeMAS.environmentName);
        dfa.addServices(vc);
        try {
            DFService.register((Agent)this, (DFAgentDescription)dfa);
        }
        catch (FIPAException e3) {
            logger.log(Level.SEVERE, "Error registering environment in DF", e3);
        }
        try {
            this.addBehaviour((Behaviour)new CyclicBehaviour(){
                ACLMessage m;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void action() {
                    this.m = JadeEnvironment.this.receive();
                    if (this.m == null) {
                        this.block(1000L);
                    } else if (this.m.getContent().equals("getPercepts")) {
                        ACLMessage r;
                        block13: {
                            r = this.m.createReply();
                            r.setPerformative(7);
                            try {
                                List<Literal> percepts = JadeEnvironment.this.userEnv.getPercepts(this.m.getSender().getLocalName());
                                if (percepts == null) {
                                    r.setContent("nothing_new");
                                    break block13;
                                }
                                List<Literal> list2 = percepts;
                                synchronized (list2) {
                                    r.setContent(percepts.toString());
                                }
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                        JadeEnvironment.this.send(r);
                    } else if (this.m.getOntology().equals(actionOntology)) {
                        ACLMessage r = this.m.createReply();
                        r.setPerformative(7);
                        try {
                            Structure action = Structure.parse(this.m.getContent());
                            JadeEnvironment.this.userEnv.scheduleAction(this.m.getSender().getLocalName(), action, r);
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                    }
                }
            });
        }
        catch (Exception e4) {
            logger.log(Level.SEVERE, "Error starting agent", e4);
        }
    }

    protected void takeDown() {
        if (this.userEnv != null) {
            this.userEnv.stop();
        }
    }

    @Override
    public void actionExecuted(String agName, Structure actTerm, boolean success, Object infraData) {
        try {
            ACLMessage r = (ACLMessage)infraData;
            if (success) {
                r.setContent("ok");
            } else {
                r.setContent("error");
            }
            this.send(r);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    @Override
    public void informAgsEnvironmentChanged() {
        this.broadcast(new Message("tell", null, null, "environmentChanged"));
    }

    @Override
    public void informAgsEnvironmentChanged(Collection<String> agentsToNotify) {
        try {
            if (agentsToNotify == null) {
                this.informAgsEnvironmentChanged();
            } else {
                ACLMessage m = new ACLMessage(7);
                m.setContent("environmentChanged");
                for (String ag : agentsToNotify) {
                    m.addReceiver(new AID(ag, false));
                }
                this.send(m);
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error sending notifyEvents ", e2);
        }
    }

    @Override
    public RuntimeServicesInfraTier getRuntimeServices() {
        return new JadeRuntimeServices((ContainerController)this.getContainerController(), this);
    }
}

