/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jason.infra.centralised.CentralisedMASLauncherAnt;
import jason.infra.jade.RunJadeMAS;
import jason.jeditplugin.Config;
import jason.jeditplugin.MASLauncherInfraTier;
import jason.mas2j.AgentParameters;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Iterator;

public class JadeMASLauncherAnt
extends CentralisedMASLauncherAnt
implements MASLauncherInfraTier {
    public static String snifferConfFile = "sniffer.properties";

    protected String replaceMarks(String script, boolean debug) {
        String jadeJar;
        File sFile = new File(String.valueOf(this.project.getDirectory()) + File.separator + snifferConfFile);
        try {
            sFile.delete();
            if (Config.get().getBoolean("jadeSniffer")) {
                PrintWriter out = new PrintWriter(new FileWriter(sFile));
                out.print("preload=");
                Iterator<AgentParameters> i = this.project.getAgents().iterator();
                while (i.hasNext()) {
                    AgentParameters ap = i.next();
                    out.print(ap.name);
                    if (!i.hasNext()) continue;
                    out.print(";");
                }
                out.println();
                out.close();
            }
        }
        catch (Exception out) {
            // empty catch block
        }
        if (!Config.checkJar(jadeJar = Config.get().getJadeJar())) {
            System.err.println("The path to the jade.jar file (" + jadeJar + ") was not correctly set. Go to menu Plugin->Options->Jason to configure the path.");
        }
        script = JadeMASLauncherAnt.replace(script, "<PROJECT-RUNNER-CLASS>", RunJadeMAS.class.getName());
        String jadepath = "\t<pathelement location=\"" + Config.get().getJadeJar() + "\"/>";
        try {
            String http = String.valueOf(new File(Config.get().getJadeJar()).getAbsoluteFile().getParent()) + "/http.jar";
            jadepath = String.valueOf(jadepath) + "\n\t<pathelement location=\"" + http + "\"/>";
        }
        catch (Exception http) {
            // empty catch block
        }
        try {
            String tools = String.valueOf(new File(Config.get().getJadeJar()).getAbsoluteFile().getParent()) + "/jadeTools.jar";
            jadepath = String.valueOf(jadepath) + "\n\t<pathelement location=\"" + tools + "\"/>";
        }
        catch (Exception tools) {
            // empty catch block
        }
        try {
            String jar = String.valueOf(new File(Config.get().getJadeJar()).getAbsoluteFile().getParent()) + "/commons-codec-1.3.jar";
            jadepath = String.valueOf(jadepath) + "\n\t<pathelement location=\"" + jar + "\"/>";
        }
        catch (Exception exception) {
            // empty catch block
        }
        script = JadeMASLauncherAnt.replace(script, "<PATH-LIB>", String.valueOf(jadepath) + "\n\t<PATH-LIB>");
        return super.replaceMarks(script, debug);
    }
}

