/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.jade;

import jade.BootProfileImpl;
import jade.core.Profile;
import jade.core.Runtime;
import jade.tools.rma.rma;
import jade.tools.sniffer.Sniffer;
import jade.wrapper.AgentController;
import jade.wrapper.ContainerController;
import jade.wrapper.StaleProxyException;
import jason.JasonException;
import jason.asSyntax.directives.DirectiveProcessor;
import jason.asSyntax.directives.Include;
import jason.control.ExecutionControlGUI;
import jason.infra.centralised.RunCentralisedMAS;
import jason.infra.jade.JadeAgArch;
import jason.infra.jade.JadeEnvironment;
import jason.infra.jade.JadeExecutionControl;
import jason.infra.jade.JadeRuntimeServices;
import jason.jeditplugin.Config;
import jason.mas2j.AgentParameters;
import jason.mas2j.ClassParameters;
import jason.mas2j.MAS2JProject;
import jason.runtime.MASConsoleGUI;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;

public class RunJadeMAS
extends RunCentralisedMAS {
    public static String controllerName = "j_controller";
    public static String environmentName = "j_environment";
    private static Logger logger = Logger.getLogger(RunJadeMAS.class.getName());
    private AgentController envc;
    private AgentController crtc;
    private Map<String, AgentController> ags = new HashMap<String, AgentController>();
    private ContainerController cc;

    public static void main(String[] args) {
        runner = new RunJadeMAS();
        runner.init(args);
    }

    protected void createButtons() {
        this.createStopButton();
        this.createPauseButton();
        JButton btRMA = new JButton("Management Agent", new ImageIcon(Sniffer.class.getResource("/jade/tools/sniffer/images/jadelogo.jpg")));
        btRMA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    RunJadeMAS.this.cc.createNewAgent("RMA", rma.class.getName(), null).start();
                }
                catch (StaleProxyException e2) {
                    e2.printStackTrace();
                }
            }
        });
        MASConsoleGUI.get().addButton(btRMA);
        JButton btSniffer = new JButton("JADE Sniffer", new ImageIcon(Sniffer.class.getResource("/jade/tools/sniffer/images/sniffer.gif")));
        btSniffer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    RunJadeMAS.this.cc.createNewAgent("Sniffer", Sniffer.class.getName(), null).start();
                }
                catch (StaleProxyException e2) {
                    e2.printStackTrace();
                }
            }
        });
        MASConsoleGUI.get().addButton(btSniffer);
    }

    protected boolean startContainer() {
        try {
            BootProfileImpl profile = new BootProfileImpl(this.prepareArgs(Config.get().getJadeArrayArgs()));
            this.cc = profile.getBooleanProperty("main", true) ? Runtime.instance().createMainContainer((Profile)profile) : Runtime.instance().createAgentContainer((Profile)profile);
            return this.cc != null;
        }
        catch (Throwable e2) {
            logger.warning("Error starting JADE:" + e2);
            return false;
        }
    }

    protected void createAg(MAS2JProject project, boolean debug) throws JasonException {
        if (!this.startContainer()) {
            return;
        }
        try {
            logger.fine("Creating environment " + project.getEnvClass());
            this.envc = this.cc.createNewAgent(environmentName, JadeEnvironment.class.getName(), new Object[]{project.getEnvClass()});
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error creating the environment: ", e2);
            return;
        }
        try {
            ClassParameters controlClass = project.getControlClass();
            if (debug && controlClass == null) {
                controlClass = new ClassParameters(ExecutionControlGUI.class.getName());
            }
            if (controlClass != null) {
                logger.fine("Creating controller " + controlClass);
                this.crtc = this.cc.createNewAgent(controllerName, JadeExecutionControl.class.getName(), new Object[]{controlClass});
            }
            project.fixAgentsSrc(null);
            ((Include)DirectiveProcessor.getDirective("include")).setSourcePath(project.getSourcePaths());
            for (AgentParameters ap : project.getAgents()) {
                try {
                    ap.setupDefault();
                    String agName = ap.name;
                    int cAg = 0;
                    while (cAg < ap.qty) {
                        String numberedAg = agName;
                        if (ap.qty > 1) {
                            numberedAg = String.valueOf(numberedAg) + (cAg + 1);
                        }
                        logger.fine("Creating agent " + numberedAg + " (" + (cAg + 1) + "/" + ap.qty + ")");
                        AgentController ac = this.cc.createNewAgent(numberedAg, JadeAgArch.class.getName(), new Object[]{ap, debug, project.getControlClass() != null});
                        this.ags.put(numberedAg, ac);
                        ++cAg;
                    }
                }
                catch (Exception e3) {
                    logger.log(Level.SEVERE, "Error creating agent " + ap.name, e3);
                }
            }
            if (Config.get().getBoolean("jadeRMA")) {
                this.cc.createNewAgent("RMA", rma.class.getName(), null).start();
            }
            if (Config.get().getBoolean("jadeSniffer")) {
                this.cc.createNewAgent("Sniffer", Sniffer.class.getName(), null).start();
                Thread.sleep(1000L);
            }
        }
        catch (Throwable e4) {
            logger.log(Level.SEVERE, "Error creating agents: ", e4);
        }
    }

    protected void startAgs() {
        if (this.envc == null) {
            return;
        }
        try {
            this.envc.start();
            if (this.crtc != null) {
                this.crtc.start();
            }
            for (AgentController ag : this.ags.values()) {
                ag.start();
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error starting agents.", e2);
        }
    }

    public void finish() {
        try {
            logger.info("Finishing the system.");
            new JadeRuntimeServices(this.cc, null).stopMAS();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error stopping system.", e2);
        }
        System.exit(0);
    }

    protected String[] prepareArgs(String[] args) {
        boolean printUsageInfo = false;
        if (args != null && args.length != 0) {
            boolean isNew = false;
            boolean likely = false;
            int i = 0;
            while (i < args.length) {
                if (args[i].startsWith("import:")) {
                    int j = args[i].indexOf(58);
                    isNew = j < args[i].length() - 1 && this.isFileName(args[i].substring(j + 1));
                    likely = !isNew;
                } else if (args[i].startsWith("agents:")) {
                    isNew = true;
                } else if (args[i].startsWith("-") && likely) {
                    isNew = true;
                }
                ++i;
            }
            if (isNew) {
                return args;
            }
        }
        int n = 0;
        boolean endCommand = false;
        Vector<String> results = new Vector<String>();
        while (n < args.length && !endCommand) {
            String theArg = args[n];
            if (theArg.equalsIgnoreCase("-conf")) {
                if (++n == args.length) {
                    results.add(theArg);
                } else {
                    String nextArg = args[n];
                    if (this.isFileName(nextArg)) {
                        results.add("import:" + nextArg);
                    } else {
                        results.add(theArg);
                        --n;
                    }
                }
            } else if (theArg.equalsIgnoreCase("-host")) {
                if (++n == args.length) {
                    System.err.println("Missing host name ");
                    printUsageInfo = true;
                } else {
                    results.add("host:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-owner")) {
                if (++n == args.length) {
                    results.add("owner::");
                } else {
                    results.add("owner:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-name")) {
                if (++n == args.length) {
                    System.err.println("Missing platform name");
                    printUsageInfo = true;
                } else {
                    results.add("name:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-imtp")) {
                if (++n == args.length) {
                    System.err.println("Missing IMTP class");
                    printUsageInfo = true;
                } else {
                    results.add("imtp:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-port")) {
                if (++n == args.length) {
                    System.err.println("Missing port number");
                    printUsageInfo = true;
                } else {
                    try {
                        Integer.parseInt(args[n]);
                    }
                    catch (NumberFormatException nfe) {
                        System.err.println("Wrong int for the port number");
                        printUsageInfo = true;
                    }
                    results.add("port:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-container")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-backupmain")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-gui")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-version") || theArg.equalsIgnoreCase("-v")) {
                results.add("-version");
            } else if (theArg.equalsIgnoreCase("-help") || theArg.equalsIgnoreCase("-h")) {
                results.add("-help");
            } else if (theArg.equalsIgnoreCase("-nomtp")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-nomobility")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-dump")) {
                results.add(theArg);
            } else if (theArg.equalsIgnoreCase("-mtp")) {
                if (++n == args.length) {
                    System.err.println("Missing mtp specifiers");
                    printUsageInfo = true;
                } else {
                    results.add("mtp:" + args[n]);
                }
            } else if (theArg.equalsIgnoreCase("-aclcodec")) {
                if (++n == args.length) {
                    System.err.println("Missing aclcodec specifiers");
                    printUsageInfo = true;
                } else {
                    results.add("aclcodec:" + args[n]);
                }
            } else if (theArg.startsWith("-") && n + 1 < args.length) {
                results.add(String.valueOf(theArg.substring(1)) + ":" + args[++n]);
            } else {
                endCommand = true;
            }
            ++n;
        }
        if (endCommand) {
            StringBuffer sb = new StringBuffer();
            int i = --n;
            while (i < args.length) {
                sb.append(String.valueOf(args[i]) + " ");
                ++i;
            }
            results.add("agents:" + sb.toString());
        }
        if (printUsageInfo) {
            results.add("-help");
        }
        String[] newArgs = new String[results.size()];
        int i = 0;
        while (i < newArgs.length) {
            newArgs[i] = (String)results.elementAt(i);
            ++i;
        }
        return newArgs;
    }

    protected boolean isFileName(String arg) {
        File testFile = new File(arg);
        return testFile.exists();
    }
}

