/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.saci;

import jason.JasonException;
import jason.asSyntax.Literal;
import jason.asSyntax.Structure;
import jason.environment.Environment;
import jason.environment.EnvironmentInfraTier;
import jason.infra.saci.SaciRuntimeServices;
import jason.runtime.RuntimeServicesInfraTier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import saci.Agent;
import saci.Message;
import saci.MessageHandler;

public class SaciEnvironment
extends Agent
implements EnvironmentInfraTier {
    private static final long serialVersionUID = 3076623775045768401L;
    private Environment userEnv;
    static Logger logger = Logger.getLogger(SaciEnvironment.class.getName());

    public void informAgsEnvironmentChanged() {
        try {
            Message m = new Message("(tell :content environmentChanged)");
            this.mbox.broadcast(m);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error sending notifyEvents ", e2);
        }
    }

    public void informAgsEnvironmentChanged(Collection agentsToNotify) {
        try {
            if (agentsToNotify == null) {
                this.informAgsEnvironmentChanged();
            } else {
                Message m = new Message("(tell :content environmentChanged)");
                Iterator i = agentsToNotify.iterator();
                while (i.hasNext()) {
                    m.put((Object)"receiver", (Object)i.next().toString());
                    this.mbox.sendMsg(m);
                }
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error sending notifyEvents ", e2);
        }
    }

    public void initAg(String[] args) throws JasonException {
        try {
            this.userEnv = (Environment)Class.forName(args[0]).newInstance();
            this.userEnv.setEnvironmentInfraTier(this);
            String[] p = new String[args.length - 1];
            int i = 0;
            while (i < p.length) {
                p[i] = args[i + 1];
                ++i;
            }
            this.userEnv.init(p);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error in Saci Environment initAg", e2);
            throw new JasonException("The user environment class instantiation '" + args[0] + "' fail!" + e2.getMessage());
        }
        try {
            this.mbox.addMessageHandler("getPercepts", "ask-all", null, "AS-Perception", new MessageHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean processMessage(Message m) {
                    Message r = null;
                    try {
                        r = new Message("(tell)");
                        r.put((Object)"receiver", m.get((Object)"sender"));
                        r.put((Object)"in-reply-to", m.get((Object)"reply-with"));
                        r.put((Object)"ontology", m.get((Object)"ontology"));
                        List<Literal> percepts = SaciEnvironment.this.userEnv.getPercepts(m.get((Object)"sender").toString());
                        if (percepts != null) {
                            List<Literal> list2 = percepts;
                            synchronized (list2) {
                                r.put((Object)"content", (Object)percepts.toString());
                            }
                        }
                        SaciEnvironment.this.mbox.sendMsg(r);
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Error sending message " + r, e2);
                    }
                    return true;
                }
            });
            this.mbox.addMessageHandler("execute", "ask", null, "AS-Action", new MessageHandler(){

                public boolean processMessage(Message m) {
                    Message r = null;
                    try {
                        r = new Message("(tell)");
                        r.put((Object)"receiver", m.get((Object)"sender"));
                        r.put((Object)"in-reply-to", m.get((Object)"reply-with"));
                        r.put((Object)"ontology", m.get((Object)"ontology"));
                        String sender = m.get((Object)"sender").toString();
                        Structure action = Structure.parse((String)m.get((Object)"action"));
                        SaciEnvironment.this.userEnv.scheduleAction(sender, action, r);
                    }
                    catch (Exception e2) {
                        logger.log(Level.SEVERE, "Error sending message " + e2, e2);
                    }
                    return true;
                }
            });
        }
        catch (Exception e3) {
            logger.log(Level.SEVERE, "Error starting agent", e3);
        }
    }

    public void actionExecuted(String agName, Structure actTerm, boolean success, Object infraData) {
        try {
            Message r = (Message)infraData;
            if (success) {
                r.put((Object)"content", (Object)"ok");
            } else {
                r.put((Object)"content", (Object)"error");
            }
            if (this.mbox != null) {
                this.mbox.sendMsg(r);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void stopAg() {
        this.userEnv.stop();
        super.stopAg();
    }

    public RuntimeServicesInfraTier getRuntimeServices() {
        return new SaciRuntimeServices(this.getSociety());
    }
}

