/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.saci;

import jason.JasonException;
import jason.architecture.AgArch;
import jason.asSemantics.Agent;
import jason.bb.DefaultBeliefBase;
import jason.infra.saci.SaciAgArch;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import jason.runtime.Settings;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import saci.CommSAg;
import saci.Facilitator;
import saci.launcher.AgentId;
import saci.launcher.Command;
import saci.launcher.Launcher;
import saci.launcher.LauncherD;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaciRuntimeServices
implements RuntimeServicesInfraTier {
    private static Logger logger = Logger.getLogger(SaciRuntimeServices.class.getName());
    private String socName = "";
    private Facilitator facilitator;

    public SaciRuntimeServices(String name) {
        this.setSocName(name);
    }

    public void setSocName(String name) {
        this.socName = name;
        try {
            Launcher l = LauncherD.getLauncher();
            String host = l.getSocietyHost(this.socName);
            this.facilitator = CommSAg.connect((String)host, (String)this.socName);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error getting facilitator for " + this.socName, e2);
        }
    }

    @Override
    public boolean createAgent(String agName, String agSource, String agClass, String archClass, ClassParameters bbPars, Settings stts) throws Exception {
        try {
            logger.fine("Creating saci agent from source " + agSource);
            if (agClass == null) {
                agClass = Agent.class.getName();
            }
            if (archClass == null) {
                archClass = AgArch.class.getName();
            }
            if (stts == null) {
                stts = new Settings();
            }
            if (bbPars == null) {
                bbPars = new ClassParameters(DefaultBeliefBase.class.getName());
            }
            String extraOp = "";
            if (stts.isSync()) {
                extraOp = " options verbose=2,synchronised=true";
            }
            Launcher l = LauncherD.getLauncher();
            Command c1 = new Command(Command.START_AGENT);
            c1.addArg("class", SaciAgArch.class.getName());
            c1.addArg("name", agName);
            c1.addArg("society.name", this.socName);
            String sBBClass = bbPars.toString().replace('\"', '$');
            c1.addArg("args", String.valueOf(archClass) + " " + agClass + " '" + sBBClass + "' " + agSource + extraOp);
            l.execCommand(c1);
            logger.fine("Agent " + agName + " created!");
            return true;
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error creating agent", e2);
            return false;
        }
    }

    @Override
    public AgArch clone(Agent source, String archClassName, String agName) throws JasonException {
        throw new JasonException("clone for SACI is not implemented!");
    }

    public Set getAgentsNames() {
        try {
            return this.facilitator.getAllWP().entrySet();
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error getting agents", e2);
            return null;
        }
    }

    @Override
    public Set<String> getAgentsName() {
        return this.getAgentsNames();
    }

    @Override
    public int getAgentsQty() {
        try {
            return this.facilitator.getAgQty() - 3;
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error getting agents qty", e2);
            return 0;
        }
    }

    @Override
    public boolean killAgent(String agName) {
        try {
            logger.fine("Killing Saci agent " + agName);
            Launcher l = LauncherD.getLauncher();
            for (AgentId aid : l.getAllAgentsID()) {
                if (!aid.getName().equals(agName) || !aid.getSociety().equals(this.socName)) continue;
                return l.killAg(aid);
            }
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error killing agent", e2);
        }
        return false;
    }

    @Override
    public void stopMAS() throws Exception {
        Launcher l = LauncherD.getLauncher();
        if (l != null) {
            l.killFacilitatorAgs(this.socName);
            l.killFacilitator(this.socName);
            l.killFacilitatorAgs(String.valueOf(this.socName) + "-env");
            l.killFacilitator(String.valueOf(this.socName) + "-env");
        }
    }
}

