/*
 * Decompiled with CFR 0.152.
 */
package jason.infra.saci;

import jason.infra.centralised.CentralisedMASLauncherAnt;
import jason.jeditplugin.Config;
import jason.mas2j.MAS2JProject;
import java.io.File;
import javax.swing.JOptionPane;
import saci.launcher.Launcher;
import saci.launcher.LauncherD;

class StartSaci
extends Thread {
    boolean saciOk = false;
    Process saciProcess;
    MAS2JProject project;
    boolean stop = false;

    StartSaci(MAS2JProject project) {
        super("StartSaci");
        this.project = project;
    }

    Launcher getLauncher() {
        Launcher l = null;
        try {
            l = LauncherD.getLauncher();
            return l;
        }
        catch (Exception e2) {
            return null;
        }
    }

    void stopSaci() {
        try {
            this.getLauncher().stop();
        }
        catch (Exception e2) {
            try {
                this.saciProcess.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.saciProcess = null;
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                block10: {
                    int tryCont;
                    block9: {
                        String[] command = this.getStartCommandArray();
                        String cmdstr = command[0];
                        int i = 1;
                        while (i < command.length) {
                            cmdstr = String.valueOf(cmdstr) + " " + command[i];
                            ++i;
                        }
                        System.out.println("Running saci with " + cmdstr);
                        this.saciProcess = Runtime.getRuntime().exec(command, null, new File(this.project.getDirectory()));
                        tryCont = 0;
                        if (!true) break block9;
                        if (tryCont >= 30) return;
                        if (this.stop) break block10;
                    }
                    do {
                        ++tryCont;
                        StartSaci.sleep(1000L);
                        Launcher l = this.getLauncher();
                        if (l != null) {
                            this.saciOk = true;
                            this.stopWaitSaciOk();
                            return;
                        }
                        if (tryCont >= 30) return;
                    } while (!this.stop);
                }
                return;
            }
            catch (Exception ex) {
                System.err.println("error running saci:" + ex);
                this.stopWaitSaciOk();
                return;
            }
        }
        finally {
            this.stopWaitSaciOk();
        }
    }

    public String[] getStartCommandArray() {
        String build = String.valueOf(CentralisedMASLauncherAnt.bindir) + "build.xml";
        if (this.hasCBuild()) {
            build = String.valueOf(CentralisedMASLauncherAnt.bindir) + "c-build.xml";
        }
        return new String[]{String.valueOf(Config.get().getJavaHome()) + "bin" + File.separator + "java", "-classpath", String.valueOf(Config.get().getAntLib()) + "ant-launcher.jar", "org.apache.tools.ant.launch.Launcher", "-e", "-f", build, "saci"};
    }

    protected boolean hasCBuild() {
        return new File(String.valueOf(this.project.getDirectory()) + File.separator + CentralisedMASLauncherAnt.bindir + "c-build.xml").exists();
    }

    synchronized void stopWaitSaciOk() {
        this.stop = true;
        this.notifyAll();
    }

    synchronized boolean waitSaciOk() {
        try {
            this.wait(20000L);
            if (!this.saciOk && !this.stop) {
                JOptionPane.showMessageDialog(null, "Failed to automatically start saci! \nGo to \"" + this.project.getDirectory() + "\" directory and run 'ant saci'" + " to start saci.\n\nClick 'ok' when saci is running.");
                this.wait(1000L);
                if (!this.saciOk) {
                    JOptionPane.showMessageDialog(null, "Saci might not be properly installed or configure. Use the centralised architecture to run your MAS");
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.saciOk;
    }
}

