/*
 * Decompiled with CFR 0.152.
 */
package jason.jeditplugin;

import jason.asSemantics.TransitionSystem;
import jason.infra.centralised.CentralisedFactory;
import jason.infra.jade.JadeFactory;
import jason.infra.saci.SaciFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class Config
extends Properties {
    private static final long serialVersionUID = 1L;
    public static final String JASON_JAR = "jasonJar";
    public static final String SACI_JAR = "saciJar";
    public static final String ANT_LIB = "antLib";
    public static final String JADE_JAR = "jadeJar";
    public static final String JADE_ARGS = "jadeArgs";
    public static final String JADE_RMA = "jadeRMA";
    public static final String JADE_SNIFFER = "jadeSniffer";
    public static final String JAVA_HOME = "javaHome";
    public static final String RUN_AS_THREAD = "runCentralisedInsideJIDE";
    public static final String SHELL_CMD = "shellCommand";
    public static final String CLOSEALL = "closeAllBeforeOpenMAS2J";
    public static final String CHECK_VERSION = "checkLatestVersion";
    public static final String WARN_SING_VAR = "warnSingletonVars";
    private static Config singleton = null;

    public static Config get() {
        return Config.get(true);
    }

    public static Config get(boolean tryToFixConfig) {
        if (singleton == null && !(singleton = new Config()).load() && tryToFixConfig) {
            singleton.fix();
            singleton.store();
        }
        return singleton;
    }

    private Config() {
    }

    public File getUserConfFile() {
        return new File(System.getProperties().get("user.home") + File.separator + ".jason/user.properties");
    }

    public boolean load() {
        try {
            File f = this.getUserConfFile();
            if (f.exists()) {
                super.load(new FileInputStream(f));
                return true;
            }
        }
        catch (Exception e2) {
            System.err.println("Error reading preferences");
            e2.printStackTrace();
        }
        return false;
    }

    public boolean getBoolean(String key) {
        return "true".equals(this.get(key));
    }

    public String getJasonJar() {
        return this.getProperty(JASON_JAR);
    }

    public String getJasonHome() {
        try {
            return new File(this.getJasonJar()).getParentFile().getParent();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return "";
        }
    }

    public String getSaciJar() {
        return this.getProperty(SACI_JAR);
    }

    public String getJadeJar() {
        return this.getProperty(JADE_JAR);
    }

    public String getJadeArgs() {
        return this.getProperty(JADE_ARGS);
    }

    public String[] getJadeArrayArgs() {
        ArrayList<String> ls = new ArrayList<String>();
        String jadeargs = this.getProperty(JADE_ARGS);
        if (jadeargs != null && jadeargs.length() > 0) {
            StringTokenizer t = new StringTokenizer(jadeargs);
            while (t.hasMoreTokens()) {
                ls.add(t.nextToken());
            }
        }
        String[] as = new String[ls.size()];
        int i = 0;
        while (i < ls.size()) {
            as[i] = (String)ls.get(i);
            ++i;
        }
        return as;
    }

    public String getJavaHome() {
        return this.getProperty(JAVA_HOME);
    }

    public String getAntLib() {
        return this.getProperty(ANT_LIB);
    }

    public void setJavaHome(String jh) {
        if (jh != null) {
            if (!(jh = new File(jh).getAbsolutePath()).endsWith(File.separator)) {
                jh = String.valueOf(jh) + File.separator;
            }
            this.put(JAVA_HOME, jh);
        }
    }

    public void setAntLib(String al) {
        if (al != null) {
            if (!(al = new File(al).getAbsolutePath()).endsWith(File.separator)) {
                al = String.valueOf(al) + File.separator;
            }
            this.put(ANT_LIB, al);
        }
    }

    public String getShellCommand() {
        return this.getProperty(SHELL_CMD);
    }

    public void fix() {
        this.tryToFixJarFileConf(JASON_JAR, "jason.jar", 600000);
        this.tryToFixJarFileConf(SACI_JAR, "saci.jar", 300000);
        this.tryToFixJarFileConf(JADE_JAR, "jade.jar", 800000);
        if (this.get(JAVA_HOME) == null || !Config.checkJavaHomePath(this.getProperty(JAVA_HOME))) {
            String javaHome = System.getProperty("java.home");
            if (Config.checkJavaHomePath(javaHome)) {
                this.setJavaHome(javaHome);
            } else {
                this.setJavaHome(File.separator);
            }
        }
        if (this.get(ANT_LIB) == null || !Config.checkAntLib(this.getAntLib())) {
            try {
                String antlib = String.valueOf(new File(this.getJasonJar()).getParentFile().getParentFile().getAbsolutePath()) + File.separator + "lib";
                if (Config.checkAntLib(antlib)) {
                    this.setAntLib(antlib);
                } else {
                    antlib = new File(".") + File.separator + "lib";
                    if (Config.checkAntLib(antlib)) {
                        this.setAntLib(antlib);
                    }
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        this.put("version", this.getJasonRunningVersion());
        if (this.get("font") == null) {
            this.put("font", "Monospaced");
        }
        if (this.get("fontSize") == null) {
            this.put("fontSize", "14");
        }
        if (this.get(SHELL_CMD) == null) {
            if (System.getProperty("os.name").startsWith("Windows 9")) {
                this.put(SHELL_CMD, "command.com /e:1024 /c ");
            } else if (System.getProperty("os.name").indexOf("indows") > 0) {
                this.put(SHELL_CMD, "cmd /c ");
            } else {
                this.put(SHELL_CMD, "/bin/sh ");
            }
        }
        if (this.get(CLOSEALL) == null) {
            this.put(CLOSEALL, "true");
        }
        if (this.get(CHECK_VERSION) == null) {
            this.put(CHECK_VERSION, "true");
        }
        if (this.getProperty(JADE_RMA) == null) {
            this.put(JADE_RMA, "true");
        }
        this.put("infrastructure.Centralised", CentralisedFactory.class.getName());
        this.put("infrastructure.Saci", SaciFactory.class.getName());
        this.put("infrastructure.Jade", JadeFactory.class.getName());
    }

    public void store() {
        try {
            File f = this.getUserConfFile();
            if (!f.getParentFile().exists()) {
                f.getParentFile().mkdirs();
            }
            super.store(new FileOutputStream(f), "Jason user configuration");
        }
        catch (Exception e2) {
            System.err.println("Error writting preferences");
            e2.printStackTrace();
        }
    }

    public String[] getAvailableInfrastructures() {
        try {
            ArrayList<String> infras = new ArrayList<String>();
            infras.add("Centralised");
            for (Object k : this.keySet()) {
                String newinfra;
                String sk = k.toString();
                int p = sk.indexOf(".");
                if (p <= 0 || !sk.startsWith("infrastructure") || p != sk.lastIndexOf(".") || infras.contains(newinfra = sk.substring(p + 1))) continue;
                infras.add(newinfra);
            }
            if (infras.size() > 0) {
                String[] r = new String[infras.size()];
                int i = 0;
                while (i < r.length) {
                    r[i] = (String)infras.get(i);
                    ++i;
                }
                return r;
            }
        }
        catch (Exception e2) {
            System.err.println("Error getting user infrastructures.");
        }
        return new String[]{"Centralised", "Jade", "Saci"};
    }

    public String getInfrastructureFactoryClass(String infraId) {
        return this.get("infrastructure." + infraId).toString();
    }

    public String getJasonRunningVersion() {
        try {
            Properties p = new Properties();
            p.load(Config.class.getResource("/dist.properties").openStream());
            return String.valueOf(p.getProperty("version")) + "." + p.getProperty("release");
        }
        catch (Exception ex) {
            return "?";
        }
    }

    void tryToFixJarFileConf(String jarEntry, String jarName, int minSize) {
        String jarFile = this.getProperty(jarEntry);
        if (jarFile == null || !Config.checkJar(jarFile)) {
            System.out.println("Wrong configuration for " + jarName + ", current is " + jarFile);
            jarFile = Config.getJavaHomePathFromClassPath(jarName);
            if (Config.checkJar(jarFile)) {
                this.put(jarEntry, jarFile);
                System.out.println("found at " + jarFile);
                return;
            }
            jarFile = "." + File.separator + jarName;
            if (Config.checkJar(jarFile)) {
                this.put(jarEntry, new File(jarFile).getAbsolutePath());
                System.out.println("found at " + jarFile);
                return;
            }
            jarFile = ".." + File.separator + "lib" + File.separator + jarName;
            if (Config.checkJar(jarFile)) {
                this.put(jarEntry, new File(jarFile).getAbsolutePath());
                System.out.println("found at " + jarFile);
                return;
            }
            jarFile = "." + File.separator + "lib" + File.separator + jarName;
            if (Config.checkJar(jarFile)) {
                this.put(jarEntry, new File(jarFile).getAbsolutePath());
                System.out.println("found at " + jarFile);
                return;
            }
            jarFile = "." + File.separator + "bin" + File.separator + jarName;
            if (Config.checkJar(jarFile)) {
                this.put(jarEntry, new File(jarFile).getAbsolutePath());
                System.out.println("found at " + jarFile);
                return;
            }
            String jwsDir = System.getProperty("jnlpx.deployment.user.home");
            if (jwsDir == null) {
                try {
                    jwsDir = System.getProperty("deployment.user.security.trusted.certs");
                    jwsDir = new File(jwsDir).getParentFile().getParent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (jwsDir != null) {
                jarFile = Config.findFile(new File(jwsDir), jarName, minSize);
                System.out.print("Searching " + jarName + " in " + jwsDir + " ... ");
                if (jarFile != null && Config.checkJar(jarFile)) {
                    System.out.println("found at " + jarFile);
                    this.put(jarEntry, jarFile);
                    return;
                }
                this.put(jarEntry, File.separator);
            }
            System.out.println(String.valueOf(jarName) + " not found");
        }
    }

    static String findFile(File p, String file, int minSize) {
        if (p.isDirectory()) {
            File[] files = p.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    String r = Config.findFile(files[i], file, minSize);
                    if (r != null) {
                        return r;
                    }
                } else if (files[i].getName().endsWith(file) && files[i].length() > (long)minSize) {
                    return files[i].getAbsolutePath();
                }
                ++i;
            }
        }
        return null;
    }

    public static boolean checkJar(String jar) {
        try {
            if (jar != null && new File(jar).exists() && jar.endsWith(".jar")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkJavaHomePath(String javaHome) {
        try {
            if (!javaHome.endsWith(File.separator)) {
                javaHome = String.valueOf(javaHome) + File.separator;
            }
            File javac1 = new File(String.valueOf(javaHome) + "bin" + File.separatorChar + "javac");
            File javac2 = new File(String.valueOf(javaHome) + "bin" + File.separatorChar + "javac.exe");
            if (javac1.exists() || javac2.exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkAntLib(String al) {
        try {
            File antjar;
            if (!al.endsWith(File.separator)) {
                al = String.valueOf(al) + File.separator;
            }
            if ((antjar = new File(String.valueOf(al) + "ant.jar")).exists()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static String getJavaHomePathFromClassPath(String file) {
        StringTokenizer st = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (!token.endsWith(file)) continue;
            return new File(token).getAbsolutePath();
        }
        return null;
    }

    public String getTemplate(String templateName) {
        try {
            String nl = System.getProperty("line.separator");
            File bt = new File("src/templates/" + templateName);
            BufferedReader in = bt.exists() ? new BufferedReader(new FileReader(bt)) : ((bt = new File("../src/templates/" + templateName)).exists() ? new BufferedReader(new FileReader(bt)) : new BufferedReader(new InputStreamReader(TransitionSystem.class.getResource("/templates/" + templateName).openStream())));
            StringBuilder scriptBuf = new StringBuilder();
            String line = in.readLine();
            while (line != null) {
                scriptBuf.append(String.valueOf(line) + nl);
                line = in.readLine();
            }
            return scriptBuf.toString();
        }
        catch (Exception e2) {
            System.err.println("Error reading template: " + templateName);
            e2.printStackTrace();
            return null;
        }
    }

    public static void main(String[] args) {
        Config.get().fix();
        Config.get().store();
    }
}

