/*
 * Decompiled with CFR 0.152.
 */
package jason.mas2j;

import jason.architecture.AgArch;
import jason.asSemantics.Agent;
import jason.asSyntax.directives.Include;
import jason.bb.DefaultBeliefBase;
import jason.mas2j.ClassParameters;
import jason.runtime.Settings;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentParameters {
    public String name = null;
    public File asSource = null;
    public ClassParameters agClass = null;
    public ClassParameters bbClass = null;
    public ClassParameters archClass = null;
    public int qty = 1;
    public String host = null;
    public Map<String, String> options = null;

    public String toString() {
        return this.getAsInMASProject();
    }

    public void setupDefault() {
        if (this.agClass == null) {
            this.agClass = new ClassParameters(Agent.class.getName());
        }
        if (this.archClass == null) {
            this.archClass = new ClassParameters(AgArch.class.getName());
        }
        if (this.bbClass == null) {
            this.bbClass = new ClassParameters(DefaultBeliefBase.class.getName());
        }
    }

    public boolean fixSrc(List<String> srcpath, String urlPrefix) {
        String r = Include.checkPathAndFixWithSourcePath(this.asSource.toString(), srcpath, urlPrefix);
        if (r != null) {
            this.asSource = new File(r);
            return true;
        }
        return false;
    }

    public ClassParameters getBBClass() {
        return this.bbClass;
    }

    public void setAgClass(String c) {
        if (c != null) {
            this.agClass = new ClassParameters(c);
        }
    }

    public void setArchClass(String c) {
        if (c != null) {
            this.archClass = new ClassParameters(c);
        }
    }

    public void setArchClass(ClassParameters c) {
        this.archClass = c;
    }

    public void setBB(ClassParameters c) {
        if (c != null) {
            this.bbClass = c;
        }
    }

    public String getAsInMASProject() {
        StringBuilder s = new StringBuilder(String.valueOf(this.name) + " ");
        if (this.asSource != null && !this.asSource.getName().startsWith(this.name)) {
            s.append(this.asSource + " ");
        }
        if (this.options != null && this.options.size() > 0) {
            s.append("[");
            Iterator<String> i = this.options.keySet().iterator();
            while (i.hasNext()) {
                String k = i.next();
                s.append(String.valueOf(k) + "=" + this.options.get(k));
                if (!i.hasNext()) continue;
                s.append(", ");
            }
            s.append("] ");
        }
        if (this.archClass != null && this.archClass.getClassName().length() > 0) {
            s.append("agentArchClass " + this.archClass + " ");
        }
        if (this.agClass != null && this.agClass.getClassName().length() > 0) {
            s.append("agentClass " + this.agClass + " ");
        }
        if (this.bbClass != null && this.bbClass.getClassName().length() > 0) {
            s.append("beliefBaseClass " + this.bbClass + " ");
        }
        if (this.qty > 1) {
            s.append("#" + this.qty + " ");
        }
        if (this.host != null && this.host.length() > 0) {
            s.append("at " + this.host);
        }
        return String.valueOf(s.toString().trim()) + ";";
    }

    public Settings getAsSetts(boolean debug, boolean forceSync) {
        Settings stts = new Settings();
        if (this.options != null) {
            String s = "";
            String v = "";
            for (String key : this.options.keySet()) {
                s = String.valueOf(s) + v + key + "=" + this.options.get(key);
                v = ",";
            }
            if (s.length() > 0) {
                stts.setOptions("[" + s + "]");
            }
        }
        if (debug) {
            stts.setVerbose(2);
        }
        if (forceSync || debug) {
            stts.setSync(true);
        }
        return stts;
    }

    public String getAgName() {
        return this.name;
    }
}

