/*
 * Decompiled with CFR 0.152.
 */
package jason.mas2j;

import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ClassParameters {
    private String className;
    private List<String> parameters = new ArrayList<String>();
    private String host;

    public ClassParameters() {
    }

    public ClassParameters(String className) {
        this.className = className;
    }

    public ClassParameters(Structure s) {
        this.className = s.getFunctor();
        if (s.getArity() > 0) {
            for (Term t : s.getTerms()) {
                this.parameters.add(t.toString());
            }
        }
    }

    public void setClassName(String cn) {
        this.className = cn;
    }

    public String getClassName() {
        return this.className;
    }

    public void addParameter(String s) {
        this.parameters.add(s);
    }

    public String getParameter(int index) {
        return this.parameters.get(index);
    }

    public boolean hasParameter(String s) {
        return this.parameters.contains(s);
    }

    public boolean hasParameters() {
        return !this.parameters.isEmpty();
    }

    public String[] getParametersArray() {
        String[] p = new String[this.parameters.size()];
        int i = 0;
        for (String s : this.parameters) {
            p[i++] = this.removeQuotes(s);
        }
        return p;
    }

    public String getParametersStr(String sep) {
        StringBuilder out = new StringBuilder();
        if (this.parameters.size() > 0) {
            Iterator<String> i = this.parameters.iterator();
            while (i.hasNext()) {
                out.append(i.next());
                if (!i.hasNext()) continue;
                out.append(sep);
            }
        }
        return out.toString();
    }

    public void setHost(String h) {
        this.host = h;
    }

    public String getHost() {
        return this.host;
    }

    public String toString() {
        StringBuilder out = new StringBuilder(this.className);
        if (this.parameters.size() > 0) {
            out.append("(");
            Iterator<String> i = this.parameters.iterator();
            while (i.hasNext()) {
                out.append(i.next());
                if (!i.hasNext()) continue;
                out.append(",");
            }
            out.append(")");
        }
        return out.toString();
    }

    String removeQuotes(String s) {
        if (s.startsWith("\"") && s.endsWith("\"")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }
}

