/*
 * Decompiled with CFR 0.152.
 */
package jason.runtime;

import jason.mas2j.parser.mas2j;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Settings {
    public static final byte ODiscard = 1;
    public static final byte ORequeue = 2;
    public static final byte ORetrieve = 3;
    public static final boolean OSameFocus = true;
    public static final boolean ONewFocus = false;
    public static final int ODefaultNRC = 1;
    public static final int ODefaultVerbose = 1;
    public static final boolean ODefaultSync = false;
    private static Logger logger = Logger.getLogger(Settings.class.getName());
    private byte events = 1;
    private boolean intBels = true;
    private int nrcbp = 1;
    private int verbose = 1;
    private boolean sync = false;
    private Map<String, Object> userParameters = new HashMap<String, Object>();

    public Settings() {
    }

    public Settings(String options) {
        this.setOptions(options);
    }

    public void setOptions(String options) {
        logger.fine("Setting options from " + options);
        mas2j parser = new mas2j(new StringReader(options));
        try {
            this.setOptions(parser.ASoptions());
            logger.fine("Settings are " + this.userParameters);
        }
        catch (Exception e2) {
            logger.log(Level.SEVERE, "Error parsing options " + options, e2);
        }
    }

    public void setOptions(Map<String, Object> options) {
        if (options == null) {
            return;
        }
        this.userParameters = options;
        for (String key : options.keySet()) {
            if (key.equals("events")) {
                String events = (String)options.get("events");
                if (events.equals("discard")) {
                    this.setEvents((byte)1);
                    continue;
                }
                if (events.equals("requeue")) {
                    this.setEvents((byte)2);
                    continue;
                }
                if (!events.equals("retrieve")) continue;
                this.setEvents((byte)3);
                continue;
            }
            if (key.equals("intBels")) {
                String intBels = (String)options.get("intBels");
                if (intBels.equals("sameFocus")) {
                    this.setIntBels(true);
                    continue;
                }
                if (!intBels.equals("newFocus")) continue;
                this.setIntBels(false);
                continue;
            }
            if (key.equals("nrcbp")) {
                String nrc = (String)options.get("nrcbp");
                this.setNRCBP(nrc);
                continue;
            }
            if (key.equals("verbose")) {
                String verbose = (String)options.get("verbose");
                this.setVerbose(verbose);
                continue;
            }
            if (!key.equals("synchronised")) continue;
            String sSync = (String)options.get("synchronised");
            if (sSync.equals("true")) {
                this.setSync(true);
                continue;
            }
            this.setSync(false);
        }
    }

    public void addOption(String key, Object value) {
        this.userParameters.put(key, value);
    }

    public void setEvents(byte opt) {
        this.events = opt;
    }

    public void setIntBels(boolean opt) {
        this.intBels = opt;
    }

    public void setNRCBP(String opt) {
        try {
            this.setNRCBP(Integer.parseInt(opt));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setNRCBP(int opt) {
        this.nrcbp = opt;
    }

    public void setVerbose(String opt) {
        try {
            this.setVerbose(Integer.parseInt(opt));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void setVerbose(int opt) {
        this.verbose = opt;
    }

    public boolean discard() {
        return this.events == 1;
    }

    public boolean requeue() {
        return this.events == 2;
    }

    public boolean retrieve() {
        return this.events == 3;
    }

    public boolean sameFocus() {
        return this.intBels;
    }

    public boolean newFocus() {
        return !this.intBels;
    }

    public int nrcbp() {
        return this.nrcbp;
    }

    public int verbose() {
        return this.verbose;
    }

    public Level logLevel() {
        switch (this.verbose) {
            case 0: {
                return Level.WARNING;
            }
            case 1: {
                return Level.INFO;
            }
            case 2: {
                return Level.FINE;
            }
        }
        return Level.INFO;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean pSync) {
        this.sync = pSync;
    }

    public Map<String, Object> getUserParameters() {
        return this.userParameters;
    }

    public String getUserParameter(String key) {
        return (String)this.userParameters.get(key);
    }
}

