/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ListTerm;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Structure;
import jason.asSyntax.Term;
import jason.mas2j.ClassParameters;
import jason.runtime.RuntimeServicesInfraTier;
import java.io.File;

public class create_agent
extends DefaultInternalAction {
    public int getMinArgs() {
        return 2;
    }

    public int getMaxArgs() {
        return 3;
    }

    protected void checkArguments(Term[] args) throws JasonException {
        super.checkArguments(args);
        if (!args[1].isString()) {
            throw JasonException.createWrongArgument(this, "second argument must be a string");
        }
        if (args.length == 3 && !args[2].isString()) {
            throw JasonException.createWrongArgument(this, "third argument must be a list");
        }
    }

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        Term name = args[0];
        StringTerm source = (StringTerm)args[1];
        File fSource = new File(source.getString());
        if (!fSource.exists()) {
            throw new JasonException("The source file " + source + " was not found!");
        }
        String agClass = null;
        String agArchClass = null;
        ClassParameters bbPars = null;
        if (args.length > 2) {
            for (Term t : (ListTerm)args[2]) {
                if (!t.isStructure()) continue;
                Structure s = (Structure)t;
                if (s.getFunctor().equals("beliefBaseClass")) {
                    bbPars = new ClassParameters(this.testString(s.getTerm(0)));
                    continue;
                }
                if (s.getFunctor().equals("agentClass")) {
                    agClass = this.testString(s.getTerm(0)).toString();
                    continue;
                }
                if (!s.getFunctor().equals("agentArchClass")) continue;
                agArchClass = this.testString(s.getTerm(0)).toString();
            }
        }
        RuntimeServicesInfraTier rs = ts.getUserAgArch().getArchInfraTier().getRuntimeServices();
        return rs.createAgent(name.toString(), fSource.getAbsolutePath(), agClass, agArchClass, bbPars, ts.getSettings());
    }

    private Structure testString(Term t) {
        if (t.isStructure()) {
            return (Structure)t;
        }
        if (t.isString()) {
            return Structure.parse(((StringTerm)t).getString());
        }
        return null;
    }
}

