/*
 * Decompiled with CFR 0.152.
 */
package jason.stdlib;

import jason.JasonException;
import jason.asSemantics.Circumstance;
import jason.asSemantics.CircumstanceListener;
import jason.asSemantics.DefaultInternalAction;
import jason.asSemantics.Event;
import jason.asSemantics.Intention;
import jason.asSemantics.TransitionSystem;
import jason.asSemantics.Unifier;
import jason.asSyntax.ASSyntax;
import jason.asSyntax.InternalActionLiteral;
import jason.asSyntax.NumberTerm;
import jason.asSyntax.NumberTermImpl;
import jason.asSyntax.PlanBody;
import jason.asSyntax.PlanBodyImpl;
import jason.asSyntax.StringTerm;
import jason.asSyntax.Term;
import jason.asSyntax.Trigger;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class wait
extends DefaultInternalAction {
    public static final String waitAtom = ".wait";

    public boolean canBeUsedInContext() {
        return false;
    }

    public boolean suspendIntention() {
        return true;
    }

    public int getMinArgs() {
        return 1;
    }

    public int getMaxArgs() {
        return 3;
    }

    public Object execute(TransitionSystem ts, Unifier un, Term[] args) throws Exception {
        this.checkArguments(args);
        long timeout = -1L;
        Trigger te = null;
        Term elapsedTime = null;
        if (args[0].isNumeric()) {
            NumberTerm time2 = (NumberTerm)args[0];
            timeout = (long)time2.solve();
        } else if (args[0].isString()) {
            te = ASSyntax.parseTrigger(((StringTerm)args[0]).getString());
            te.getLiteral().apply(un);
            if (args.length >= 2) {
                timeout = (long)((NumberTerm)args[1]).solve();
            }
            if (args.length == 3) {
                elapsedTime = args[2];
            }
        }
        new WaitEvent(te, un, ts, timeout, elapsedTime);
        return true;
    }

    class WaitEvent
    implements CircumstanceListener {
        private Trigger te;
        private String sTE;
        private Unifier un;
        private Intention si;
        private TransitionSystem ts;
        private Circumstance c;
        private boolean dropped = false;
        private Term elapsedTimeTerm;
        private long startTime;

        WaitEvent(Trigger te, Unifier un, TransitionSystem ts, long timeout, Term elapsedTimeTerm) {
            this.te = te;
            this.un = un;
            this.ts = ts;
            this.c = ts.getC();
            this.si = this.c.getSelectedIntention();
            this.elapsedTimeTerm = elapsedTimeTerm;
            this.c.addEventListener(this);
            this.sTE = te != null ? te.toString() : "time" + timeout;
            this.sTE = String.valueOf(this.si.getId()) + "/" + this.sTE;
            this.c.getPendingIntentions().put(this.sTE, this.si);
            this.startTime = System.currentTimeMillis();
            if (timeout > 0L) {
                ts.getAg().getScheduler().schedule(new Runnable(){

                    public void run() {
                        WaitEvent.this.resume(true);
                    }
                }, timeout, TimeUnit.MILLISECONDS);
            }
        }

        void resume(boolean stopByTimeout) {
            try {
                this.c.removeEventListener(this);
                if (this.c.getPendingIntentions().remove(this.sTE) == this.si && !this.c.getIntentions().contains(this.si) && !this.dropped) {
                    if (stopByTimeout && this.te != null && this.elapsedTimeTerm == null) {
                        if (this.si.isSuspended()) {
                            PlanBody body = this.si.peek().getPlan().getBody();
                            body.add(1, new PlanBodyImpl(PlanBody.BodyType.internalAction, new InternalActionLiteral(".fail")));
                            this.c.getPendingIntentions().put("suspended-" + this.si.getId(), this.si);
                        } else {
                            this.ts.generateGoalDeletion(this.si, JasonException.createBasicErrorAnnots("wait_timeout", "timeout in .wait"));
                        }
                    } else {
                        this.si.peek().removeCurrentStep();
                        if (this.elapsedTimeTerm != null) {
                            long elapsedTime = System.currentTimeMillis() - this.startTime;
                            this.un.unifies(this.elapsedTimeTerm, new NumberTermImpl(elapsedTime));
                        }
                        if (this.si.isSuspended()) {
                            this.c.getPendingIntentions().put("suspended-" + this.si.getId(), this.si);
                        } else {
                            this.c.addIntention(this.si);
                        }
                    }
                    this.ts.getUserAgArch().getArchInfraTier().wake();
                }
            }
            catch (Exception e2) {
                this.ts.getLogger().log(Level.SEVERE, "Error at .wait thread", e2);
            }
        }

        public void eventAdded(Event e2) {
            if (this.te != null && !this.dropped && this.un.unifies(this.te, e2.getTrigger())) {
                this.resume(false);
            }
        }

        public void intentionDropped(Intention i) {
            if (i.equals(this.si)) {
                this.dropped = true;
                this.resume(false);
            }
        }

        public void intentionAdded(Intention i) {
        }

        public String toString() {
            return this.sTE;
        }
    }
}

