/*
 * Decompiled with CFR 0.152.
 */
package jason.tests;

import jason.asunit.TestAgent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestKQML {
    TestAgent bob;
    TestAgent maria;

    @Before
    public void setupAgs() {
        this.bob = new TestAgent("bob");
        this.maria = new TestAgent("maria");
        this.bob.parseAScode("+!simple_send <- .send(maria, tell, vl(10));                  .send(maria, achieve, goto(10,2));                  .send(maria, tell, loves(maria,bob)[source(maria), source(mog)]). +!send_ask1   <- .send(maria, askOne, vl(_), vl(X));                  .send(maria, askOne, vl(_));                  act1(X). +!send_ask2   <- .send(maria, askOne, t2(_), A);                  jason.asunit.print(A). +!send_ask3   <- .send(maria, askOne, t1(_), A);                  jason.asunit.print(t1,\" \",A). +!send_ask4   <- .send(maria, askOne, fullname, A);                  jason.asunit.print(A). +!send_askAll1 <- .send(maria, askAll, vl(_), L);                   jason.asunit.print(L). +!send_askAll2 <- .send(maria, askAll, t1(_), L);                   jason.asunit.print(L). +!send_tellHow   <- .plan_label(Plan,hp);                    .send(maria,tellHow,Plan);                     .send(maria,achieve, hello(bob)). +!send_untellHow <- .send(maria,untellHow,hp). @hp +!hello(Who)  <- jason.asunit.print(\"Hello \",Who).");
        this.maria.parseAScode("vl(1). vl(2). +!goto(X,Y)[source(Ag)] <- act(X,Y,Ag). +?t2(X) : vl(Y) <- X = 10 + Y.+!kqml_received(Sender, askOne, fullname, ReplyWith)  <- .send(Sender,tell,\"Maria dos Santos\", ReplyWith). ");
    }

    @Test
    public void testSend() {
        this.bob.addGoal("simple_send");
        this.bob.assertIdle(5);
        this.maria.assertBel("vl(10)[source(bob)]", 5);
        this.maria.assertAct("act(10,2,bob)", 5);
        this.maria.assertBel("loves(maria,bob)[source(bob)[source(maria),source(mog)]]", 5);
    }

    @Test
    public void testAsk() {
        this.bob.addGoal("send_ask1");
        this.bob.addGoal("send_ask2");
        this.bob.assertIdle(10);
        this.maria.assertIdle(10);
        this.bob.assertAct("act1(1)", 5);
        this.maria.assertIdle(5);
        this.bob.assertBel("vl(1)[source(maria)]", 5);
        this.bob.assertPrint("t2(11)", 5);
    }

    @Test
    public void testAsk3() {
        this.bob.addGoal("send_ask3");
        this.bob.assertIdle(10);
        this.maria.assertIdle(10);
        this.bob.assertPrint("t1 false", 5);
        this.bob.addGoal("send_ask4");
        this.bob.assertIdle(10);
        this.maria.assertIdle(10);
        this.bob.assertPrint("Maria dos Santos", 5);
    }

    @Test
    public void testAskAll() {
        this.bob.addGoal("simple_send");
        this.bob.addGoal("send_askAll1");
        this.bob.assertIdle(10);
        this.maria.assertIdle(15);
        this.bob.assertPrint("[vl(10),vl(1),vl(2)]", 5);
        this.bob.addGoal("send_askAll2");
        this.bob.assertIdle(10);
        this.maria.assertIdle(10);
        this.bob.assertPrint("[]", 5);
    }

    @Test
    public void testTellHow() {
        this.bob.addGoal("send_tellHow");
        this.bob.assertIdle(10);
        this.maria.assertPrint("Hello bob", 10);
        this.bob.addGoal("send_untellHow");
        this.bob.assertIdle(10);
        this.maria.assertIdle(10);
        Assert.assertTrue((this.maria.getPL().get("hp") == null ? 1 : 0) != 0);
    }
}

