/*
 * Decompiled with CFR 0.152.
 */
package jason.util;

import jason.asSemantics.Agent;
import jason.asSyntax.parser.as2j;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;

public class asl2xml {
    protected Transformer transCache = null;
    TransformerFactory fac = null;

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("The asl code file must be informed");
            System.exit(1);
        }
        new asl2xml().run(args[0]);
    }

    void run(String file) throws Exception {
        Agent ag = this.loadAg(file);
        if (ag != null) {
            System.out.println(this.transform(ag));
        }
    }

    Agent loadAg(String file) throws Exception {
        Agent ag = new Agent();
        if (ag.parseAS(new File(file))) {
            ag.setASLSrc(file);
            ag.addInitialBelsInBB();
            return ag;
        }
        return null;
    }

    public String transform(String agCode) throws Exception {
        as2j parser = new as2j(new StringReader(agCode));
        Agent ag = new Agent();
        parser.agent(ag);
        return this.transform(ag.getAgProgram());
    }

    public String transform(Agent ag) throws Exception {
        return this.transform(ag.getAgProgram());
    }

    public String transform(Document agState) throws Exception {
        StringWriter so = new StringWriter();
        this.getTransformer().transform(new DOMSource(agState), new StreamResult(so));
        return so.toString();
    }

    public Transformer getTransformer() throws Exception {
        if (this.transCache == null) {
            this.transCache = this.getFactory().newTransformer();
            this.transCache.setOutputProperty("indent", "yes");
        }
        return this.transCache;
    }

    TransformerFactory getFactory() throws Exception {
        if (this.fac == null) {
            this.fac = TransformerFactory.newInstance();
            this.fac.setURIResolver(new URIResolver(){

                public Source resolve(String href, String base) throws TransformerException {
                    try {
                        return new StreamSource(asl2xml.class.getResource("/xml/" + href).openStream());
                    }
                    catch (Exception e2) {
                        System.err.println("Error - " + href + "-" + base);
                        e2.printStackTrace();
                        return null;
                    }
                }
            });
        }
        return this.fac;
    }
}

