/*
 * Decompiled with CFR 0.152.
 */
package busca;

import busca.Estado;
import busca.Heuristica;

public class Nodo
implements Comparable {
    Estado estado;
    Nodo pai;
    int profundidade = 0;
    int g = 0;
    int f = -1;

    public Nodo(Estado e, Nodo p) {
        this.estado = e;
        this.pai = p;
        if (p == null) {
            this.profundidade = 0;
            this.g = e.custo();
        } else {
            this.profundidade = p.getProfundidade() + 1;
            this.g = e.custo() + p.g;
        }
    }

    public int getProfundidade() {
        return this.profundidade;
    }

    public Estado getEstado() {
        return this.estado;
    }

    public Nodo getPai() {
        return this.pai;
    }

    public int g() {
        return this.g;
    }

    public int f() {
        if (this.f == -1) {
            this.f = this.g + ((Heuristica)((Object)this.estado)).h();
        }
        return this.f;
    }

    void invertePaternidade() {
        if (this.pai.pai != null) {
            this.pai.invertePaternidade();
        }
        this.pai.pai = this;
    }

    void setProfundidade() {
        if (this.pai == null) {
            this.profundidade = 0;
        } else {
            this.pai.setProfundidade();
            this.profundidade = this.pai.getProfundidade() + 1;
        }
    }

    boolean ehDescendenteNovo(Nodo ascensor) {
        if (ascensor == null) {
            return true;
        }
        if (ascensor.estado.equals(this.estado)) {
            return false;
        }
        return this.ehDescendenteNovo(ascensor.pai);
    }

    public boolean equals(Object o) {
        try {
            Nodo n = (Nodo)o;
            return this.estado.equals(n.estado);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int compareTo(Object obj) {
        try {
            Nodo outro = (Nodo)obj;
            if (this.g > outro.g) {
                return 1;
            }
            if (this.g == outro.g) {
                return 0;
            }
            return -1;
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return 0;
        }
    }

    public String montaCaminho() {
        return this.montaCaminho(this);
    }

    public String montaCaminho(Nodo n) {
        if (n != null) {
            return this.montaCaminho(n.pai) + n + "; ";
        }
        return "";
    }

    public String toString() {
        return this.estado.toString();
    }
}

