/*
 * Decompiled with CFR 0.152.
 */
package exemplos;

import busca.Antecessor;
import busca.BuscaLargura;
import busca.Estado;
import busca.Heuristica;
import busca.MostraStatusConsole;
import busca.Nodo;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Estado8Puzzle
implements Estado,
Heuristica,
Antecessor {
    public static short tam = (short)3;
    int[][] tabuleiro = new int[tam][tam];
    int colBranco = -1;
    int linBranco = -1;
    private String toStringCache = null;
    private static final Estado8Puzzle estadoMeta = Estado8Puzzle.setEstadoMeta();

    @Override
    public String getDescricao() {
        return "Este problema consiste em posicionar 8\nn\u02d9meros em um tabuleiro 3x3 na seguinte dispos\u00c1\u201eo:\n1 2 3\n8   4\n7 6 5\nsendo que o espa\u00c1o pode se mover.\n(bom candidato \u2021 busca bi-direcional)\n";
    }

    public Estado8Puzzle() {
        int r = 0;
        while (r < tam * tam) {
            int l = Math.round((float)(Math.random() * (double)(tam - 1)));
            int c = Math.round((float)(Math.random() * (double)(tam - 1)));
            while (this.tabuleiro[l][c] != 0) {
                l = Math.round((float)(Math.random() * (double)(tam - 1)));
                c = Math.round((float)(Math.random() * (double)(tam - 1)));
            }
            this.tabuleiro[l][c] = r++;
        }
        this.setPosBranco();
    }

    Estado8Puzzle(int[][] p) {
        int l = 0;
        while (l < tam) {
            int c = 0;
            while (c < tam) {
                this.tabuleiro[l][c] = p[l][c];
                ++c;
            }
            ++l;
        }
    }

    void setPosBranco() {
        int l = 0;
        while (l < tam) {
            int c = 0;
            while (c < tam) {
                if (this.tabuleiro[l][c] == 0) {
                    this.colBranco = c;
                    this.linBranco = l;
                }
                ++c;
            }
            ++l;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean equals(Object o) {
        try {
            Estado8Puzzle e = (Estado8Puzzle)o;
            int l = 0;
            block2: while (true) {
                if (l >= tam) {
                    return true;
                }
                int c = 0;
                while (true) {
                    if (c >= tam) {
                        ++l;
                        continue block2;
                    }
                    if (this.tabuleiro[l][c] != e.tabuleiro[l][c]) {
                        return false;
                    }
                    ++c;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean ehMeta() {
        return this.equals(estadoMeta);
    }

    @Override
    public int h() {
        return this.h2() + this.h3();
    }

    public int h1() {
        int fora = 0;
        if (this.tabuleiro[0][0] != 1) {
            ++fora;
        }
        if (this.tabuleiro[0][1] != 2) {
            ++fora;
        }
        if (this.tabuleiro[0][2] != 3) {
            ++fora;
        }
        if (this.tabuleiro[1][0] != 8) {
            ++fora;
        }
        if (this.tabuleiro[1][1] != 0) {
            ++fora;
        }
        if (this.tabuleiro[1][2] != 4) {
            ++fora;
        }
        if (this.tabuleiro[2][0] != 7) {
            ++fora;
        }
        if (this.tabuleiro[2][1] != 6) {
            ++fora;
        }
        if (this.tabuleiro[2][2] != 5) {
            ++fora;
        }
        return fora;
    }

    public int h2() {
        int fora = 0;
        int n = 0;
        while (n < tam * tam) {
            int l = this.getLinNro(n);
            int c = this.getColNro(n);
            int lMeta = estadoMeta.getLinNro(n);
            int cMeta = estadoMeta.getColNro(n);
            fora += Math.abs(l - lMeta);
            fora += Math.abs(c - cMeta);
            ++n;
        }
        return fora;
    }

    public int h3() {
        int fora = 0;
        int n = 1;
        while (n < tam * tam) {
            int l = this.getLinNro(n);
            int c = this.getColNro(n);
            int lAnt = 0;
            if (l == 0 && c == 0) {
                lAnt = 1;
            } else if (l == 0 && c == 1) {
                lAnt = 0;
            } else if (l == 0 && c == 2) {
                lAnt = 0;
            } else if (l == 1 && c == 0) {
                lAnt = 2;
            } else if (l == 1 && c == 2) {
                lAnt = 0;
            } else if (l == 2 && c == 0) {
                lAnt = 2;
            } else if (l == 2 && c == 1) {
                lAnt = 2;
            } else if (l == 2 && c == 2) {
                lAnt = 1;
            }
            int cAnt = 0;
            if (l == 0 && c == 0) {
                cAnt = 0;
            } else if (l == 0 && c == 1) {
                cAnt = 0;
            } else if (l == 0 && c == 2) {
                cAnt = 1;
            } else if (l == 1 && c == 0) {
                cAnt = 0;
            } else if (l == 1 && c == 2) {
                cAnt = 2;
            } else if (l == 2 && c == 0) {
                cAnt = 1;
            } else if (l == 2 && c == 1) {
                cAnt = 2;
            } else if (l == 2 && c == 2) {
                cAnt = 2;
            }
            int nroAnt = this.tabuleiro[lAnt][cAnt];
            if (n == 1) {
                if (nroAnt != 8) {
                    ++fora;
                }
            } else if (nroAnt + 1 != n) {
                ++fora;
            }
            ++n;
        }
        return fora;
    }

    int getColNro(int n) {
        int l = 0;
        while (l < tam) {
            int c = 0;
            while (c < tam) {
                if (this.tabuleiro[l][c] == n) {
                    return c;
                }
                ++c;
            }
            ++l;
        }
        return -1;
    }

    int getLinNro(int n) {
        int l = 0;
        while (l < tam) {
            int c = 0;
            while (c < tam) {
                if (this.tabuleiro[l][c] == n) {
                    return l;
                }
                ++c;
            }
            ++l;
        }
        return -1;
    }

    @Override
    public List<Estado> sucessores() {
        Estado8Puzzle novo;
        LinkedList<Estado> suc = new LinkedList<Estado>();
        if (this.linBranco > 0) {
            novo = new Estado8Puzzle(this.tabuleiro);
            novo.tabuleiro[this.linBranco - 1][this.colBranco] = 0;
            novo.tabuleiro[this.linBranco][this.colBranco] = this.tabuleiro[this.linBranco - 1][this.colBranco];
            novo.linBranco = this.linBranco - 1;
            novo.colBranco = this.colBranco;
            suc.add(novo);
        }
        if (this.linBranco < tam - 1) {
            novo = new Estado8Puzzle(this.tabuleiro);
            novo.tabuleiro[this.linBranco + 1][this.colBranco] = 0;
            novo.tabuleiro[this.linBranco][this.colBranco] = this.tabuleiro[this.linBranco + 1][this.colBranco];
            novo.linBranco = this.linBranco + 1;
            novo.colBranco = this.colBranco;
            suc.add(novo);
        }
        if (this.colBranco > 0) {
            novo = new Estado8Puzzle(this.tabuleiro);
            novo.tabuleiro[this.linBranco][this.colBranco - 1] = 0;
            novo.tabuleiro[this.linBranco][this.colBranco] = this.tabuleiro[this.linBranco][this.colBranco - 1];
            novo.linBranco = this.linBranco;
            novo.colBranco = this.colBranco - 1;
            suc.add(novo);
        }
        if (this.colBranco < tam - 1) {
            novo = new Estado8Puzzle(this.tabuleiro);
            novo.tabuleiro[this.linBranco][this.colBranco + 1] = 0;
            novo.tabuleiro[this.linBranco][this.colBranco] = this.tabuleiro[this.linBranco][this.colBranco + 1];
            novo.linBranco = this.linBranco;
            novo.colBranco = this.colBranco + 1;
            suc.add(novo);
        }
        return suc;
    }

    @Override
    public List<Estado> antecessores() {
        return this.sucessores();
    }

    public boolean temSolucao() {
        Estado8Puzzle meta = estadoMeta;
        Estado8Puzzle t = new Estado8Puzzle(this.tabuleiro);
        int cb = t.getColNro(0);
        int lb = t.getLinNro(0);
        while (lb < meta.getLinNro(0)) {
            this.troca(t.tabuleiro, lb, cb, lb + 1, cb);
            ++lb;
        }
        while (lb > meta.getLinNro(0)) {
            this.troca(t.tabuleiro, lb, cb, lb - 1, cb);
            --lb;
        }
        while (cb < meta.getColNro(0)) {
            this.troca(t.tabuleiro, lb, cb, lb, cb + 1);
            ++cb;
        }
        while (cb > meta.getColNro(0)) {
            this.troca(t.tabuleiro, lb, cb, lb, cb - 1);
            --cb;
        }
        int nroTrocas = 0;
        int l = 0;
        while (l < tam) {
            int c = 0;
            while (c < tam) {
                if (t.tabuleiro[l][c] != meta.tabuleiro[l][c]) {
                    int vlOk = meta.tabuleiro[l][c];
                    this.troca(t.tabuleiro, l, c, t.getLinNro(vlOk), t.getColNro(vlOk));
                    ++nroTrocas;
                }
                ++c;
            }
            ++l;
        }
        return nroTrocas % 2 == 0;
    }

    private void troca(int[][] tab, int l1, int c1, int l2, int c2) {
        int bak = tab[l2][c2];
        tab[l2][c2] = tab[l1][c1];
        tab[l1][c1] = bak;
    }

    public String toString() {
        if (this.toStringCache == null) {
            StringBuffer r = new StringBuffer("\n");
            int i = 0;
            while (i < tam) {
                int j = 0;
                while (j < tam) {
                    r.append(this.tabuleiro[i][j]);
                    if (j + 1 < tam) {
                        r.append(" ");
                    }
                    ++j;
                }
                if (i + 1 < tam) {
                    r.append("\n");
                }
                ++i;
            }
            this.toStringCache = r + "\n";
        }
        return this.toStringCache;
    }

    @Override
    public int custo() {
        return 1;
    }

    public static Estado8Puzzle getEstadoFacil() {
        int[][] nArrayArray = new int[3][];
        nArrayArray[0] = new int[]{8, 1, 3};
        int[] nArray = new int[3];
        nArray[1] = 7;
        nArray[2] = 2;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{6, 5, 4};
        Estado8Puzzle e8 = new Estado8Puzzle(nArrayArray);
        e8.setPosBranco();
        return e8;
    }

    public static Estado8Puzzle getEstadoDificil() {
        int[][] nArrayArray = new int[3][];
        nArrayArray[0] = new int[]{7, 8, 6};
        nArrayArray[1] = new int[]{2, 3, 5};
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[1] = 4;
        nArrayArray[2] = nArray;
        Estado8Puzzle e8 = new Estado8Puzzle(nArrayArray);
        e8.setPosBranco();
        return e8;
    }

    public static Estado8Puzzle getEstadoMuitoDificil() {
        int[][] nArrayArray = new int[3][];
        nArrayArray[0] = new int[]{2, 3, 4};
        int[] nArray = new int[3];
        nArray[0] = 1;
        nArray[2] = 5;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{8, 7, 6};
        Estado8Puzzle e8 = new Estado8Puzzle(nArrayArray);
        e8.setPosBranco();
        return e8;
    }

    public static Estado8Puzzle getEstadoMeta() {
        return estadoMeta;
    }

    private static Estado8Puzzle setEstadoMeta() {
        int[][] nArrayArray = new int[3][];
        nArrayArray[0] = new int[]{1, 2, 3};
        int[] nArray = new int[3];
        nArray[0] = 8;
        nArray[2] = 4;
        nArrayArray[1] = nArray;
        nArrayArray[2] = new int[]{7, 6, 5};
        Estado8Puzzle e8 = new Estado8Puzzle(nArrayArray);
        e8.setPosBranco();
        return e8;
    }

    public static void main(String[] a) {
        Estado8Puzzle e8 = Estado8Puzzle.getEstadoDificil();
        System.out.println("estado inicial (h=" + e8.h() + ") =" + e8);
        if (!e8.temSolucao()) {
            System.out.println(e8 + "n\u201eo tem solu\u00c1\u201eo!");
            return;
        }
        Nodo s = new BuscaLargura(new MostraStatusConsole()).busca(e8);
        if (s != null) {
            System.out.println("solu\u00c1\u201eo (" + s.getProfundidade() + ")= " + s.montaCaminho());
        }
    }
}

