/*
 * Decompiled with CFR 0.152.
 */
package exemplos;

import busca.Antecessor;
import busca.BuscaLargura;
import busca.Estado;
import busca.Nodo;
import grafo.Grafo;
import grafo.GrafoNaoDirigido;
import grafo.Vertice;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EstadoMapa
implements Estado,
Antecessor {
    int cidade;
    int custo = 1;
    public static Grafo mapa = new GrafoNaoDirigido();
    public static final char[] nomes;
    private static int meta;

    static {
        int i = 0;
        while (i <= 15) {
            mapa.criaVertice(i);
            ++i;
        }
        mapa.criaAresta(0, 1, 3);
        mapa.criaAresta(0, 2, 6);
        mapa.criaAresta(1, 9, 3);
        mapa.criaAresta(1, 7, 3);
        mapa.criaAresta(2, 13, 2);
        mapa.criaAresta(2, 14, 2);
        mapa.criaAresta(2, 3, 3);
        mapa.criaAresta(2, 6, 2);
        mapa.criaAresta(3, 4, 1);
        mapa.criaAresta(3, 5, 1);
        mapa.criaAresta(4, 5, 1);
        mapa.criaAresta(4, 8, 2);
        mapa.criaAresta(4, 11, 14);
        mapa.criaAresta(5, 6, 1);
        mapa.criaAresta(6, 7, 2);
        mapa.criaAresta(7, 8, 2);
        mapa.criaAresta(7, 9, 4);
        mapa.criaAresta(9, 10, 1);
        mapa.criaAresta(9, 12, 3);
        mapa.criaAresta(11, 12, 2);
        mapa.criaAresta(11, 15, 1);
        nomes = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'k', 'l', 'm', 'n', 'o', 'p', 'x'};
    }

    @Override
    public String getDescricao() {
        StringBuffer ds = new StringBuffer("Encontra rotas no mapa abaixo (o custo dos caminhos esta entre parenteses):\n");
        int i = 0;
        while (i < nomes.length) {
            ds.append("  saindo de " + nomes[i] + " para ");
            Map<Vertice, Integer> custos = mapa.getVertice(i).getCustoAdjacentes();
            for (Vertice v : custos.keySet()) {
                ds.append(String.valueOf(nomes[v.getId()]) + "(" + custos.get(v) + "), ");
            }
            ds.append("\n");
            ++i;
        }
        return ds.toString();
    }

    public EstadoMapa(int c) {
        this.cidade = c;
    }

    EstadoMapa(int c, int custo) {
        this.cidade = c;
        this.custo = custo;
    }

    public boolean equals(Object o) {
        try {
            EstadoMapa e = (EstadoMapa)o;
            return e.cidade == this.cidade;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return new Integer(this.cidade).hashCode();
    }

    @Override
    public boolean ehMeta() {
        return this.cidade == meta;
    }

    @Override
    public int custo() {
        return this.custo;
    }

    @Override
    public List<Estado> sucessores() {
        LinkedList<Estado> suc = new LinkedList<Estado>();
        Map<Vertice, Integer> custos = mapa.getVertice(this.cidade).getCustoAdjacentes();
        for (Vertice v : custos.keySet()) {
            suc.add(new EstadoMapa(v.getId(), custos.get(v)));
        }
        return suc;
    }

    @Override
    public List<Estado> antecessores() {
        return this.sucessores();
    }

    public String toString() {
        return String.valueOf(nomes[this.cidade]) + " ";
    }

    public static int getMeta() {
        return meta;
    }

    public static void setMeta(int cidade) {
        meta = cidade;
    }

    public static void main(String[] a) {
        EstadoMapa inicial = new EstadoMapa(8);
        EstadoMapa.setMeta(15);
        System.out.println(inicial.getDescricao());
        System.out.println("estado inicial= " + inicial);
        Nodo s = new BuscaLargura().busca(inicial);
        if (s != null) {
            System.out.println("solu\u00c1\u201eo = " + s.montaCaminho());
            System.out.println("\topera\u00c1\u0131es = " + s.getProfundidade());
            System.out.println("\tcusto = " + s.g());
        }
    }
}

