/*
 * Decompiled with CFR 0.152.
 */
package exemplos;

import busca.Aleatorio;
import busca.Estado;
import busca.Heuristica;
import busca.MostraStatusConsole;
import busca.Nodo;
import busca.SubidaMontanha;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EstadoRainhas
implements Estado,
Heuristica,
Aleatorio {
    static short tam = (short)8;
    int[][] posicoes = new int[tam][2];

    @Override
    public String getDescricao() {
        return "Este problema consiste em posicionar 8\nrainhas do jogo de xadrez em um tabuleiro,\nsendo que nenhuma pode atacar a outra.\n(tem heur\u00edstica implementada)\n";
    }

    public static void setTamanho(int t) {
        tam = (short)t;
    }

    public EstadoRainhas() {
        for (int r = 0; r < tam; ++r) {
            int l = Math.round((float)(Math.random() * (double)(tam - 1)));
            int c = Math.round((float)(Math.random() * (double)(tam - 1)));
            while (this.getPos(l, c) != -1) {
                l = Math.round((float)(Math.random() * (double)(tam - 1)));
                c = Math.round((float)(Math.random() * (double)(tam - 1)));
            }
            this.setPosRainha(r, l, c);
        }
    }

    EstadoRainhas(int[][] p) {
        for (int r = 0; r < tam; ++r) {
            this.posicoes[r][0] = p[r][0];
            this.posicoes[r][1] = p[r][1];
        }
    }

    @Override
    public Estado geraAleatorio() {
        return new EstadoRainhas();
    }

    public void setPosRainha(int r, int l, int c) {
        this.posicoes[r][0] = l;
        this.posicoes[r][1] = c;
    }

    public int getPos(int l, int c) {
        for (int r = 0; r < tam; ++r) {
            if (this.posicoes[r][0] != l || this.posicoes[r][1] != c) continue;
            return r;
        }
        return -1;
    }

    public String getPosStr(int l, int c) {
        int r = this.getPos(l, c);
        if (r == -1) {
            return "_";
        }
        return "" + r;
    }

    public boolean equals(Object o) {
        try {
            EstadoRainhas e = (EstadoRainhas)o;
            for (short r = 0; r < tam; r = (short)(r + 1)) {
                if (this.posicoes[r][0] != e.posicoes[r][0]) {
                    return false;
                }
                if (this.posicoes[r][1] == e.posicoes[r][1]) continue;
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean ehMeta() {
        return this.h() == 0;
    }

    @Override
    public int h() {
        int ataques = 0;
        for (short r = 0; r < tam; r = (short)(r + 1)) {
            int naPos;
            int c;
            int l;
            int naPos2;
            for (int c2 = 0; c2 < tam; ++c2) {
                naPos2 = this.getPos(this.posicoes[r][0], c2);
                if (naPos2 == -1 || naPos2 == r) continue;
                ++ataques;
            }
            for (l = 0; l < tam; ++l) {
                naPos2 = this.getPos(l, this.posicoes[r][1]);
                if (naPos2 == -1 || naPos2 == r) continue;
                ++ataques;
            }
            l = Math.max(this.posicoes[r][0] - this.posicoes[r][1], 0);
            for (c = Math.max(this.posicoes[r][1] - this.posicoes[r][0], 0); l < tam && c < tam; ++l, ++c) {
                naPos = this.getPos(l, c);
                if (naPos == -1 || naPos == r) continue;
                ++ataques;
            }
            l = Math.min(this.posicoes[r][0] + this.posicoes[r][1], tam - 1);
            for (c = Math.max(this.posicoes[r][1] - (tam - 1 - this.posicoes[r][0]), 0); l >= 0 && c < tam; --l, ++c) {
                naPos = this.getPos(l, c);
                if (naPos == -1 || naPos == r) continue;
                ++ataques;
            }
        }
        return ataques;
    }

    @Override
    public List<Estado> sucessores() {
        LinkedList<Estado> suc = new LinkedList<Estado>();
        for (short r = 0; r < tam; r = (short)(r + 1)) {
            EstadoRainhas novo;
            int i;
            int inc = 1;
            int fixo = 0;
            int var = 1;
            for (i = this.posicoes[r][var] + inc; i < tam && i >= 0 && this.getPos(this.posicoes[r][fixo], i) == -1; i += inc) {
                novo = new EstadoRainhas(this.posicoes);
                novo.setPosRainha(r, this.posicoes[r][fixo], i);
                suc.add(novo);
            }
            inc = -1;
            fixo = 0;
            var = 1;
            for (i = this.posicoes[r][var] + inc; i < tam && i >= 0 && this.getPos(this.posicoes[r][fixo], i) == -1; i += inc) {
                novo = new EstadoRainhas(this.posicoes);
                novo.setPosRainha(r, this.posicoes[r][fixo], i);
                suc.add(novo);
            }
            inc = 1;
            fixo = 1;
            var = 0;
            for (i = this.posicoes[r][var] + inc; i < tam && i >= 0 && this.getPos(i, this.posicoes[r][fixo]) == -1; i += inc) {
                novo = new EstadoRainhas(this.posicoes);
                novo.setPosRainha(r, i, this.posicoes[r][fixo]);
                suc.add(novo);
            }
            inc = -1;
            fixo = 1;
            var = 0;
            for (i = this.posicoes[r][var] + inc; i < tam && i >= 0 && this.getPos(i, this.posicoes[r][fixo]) == -1; i += inc) {
                novo = new EstadoRainhas(this.posicoes);
                novo.setPosRainha(r, i, this.posicoes[r][fixo]);
                suc.add(novo);
            }
        }
        return suc;
    }

    public String toString() {
        StringBuffer r = new StringBuffer("\n");
        for (int i = 0; i < tam; ++i) {
            for (int j = 0; j < tam; ++j) {
                r.append(this.getPosStr(i, j));
                if (j + 1 >= tam) continue;
                r.append(" ");
            }
            r.append("\n");
        }
        return r.toString();
    }

    @Override
    public int custo() {
        return 1;
    }

    public static void main(String[] a) {
        tam = (short)8;
        EstadoRainhas inicial = new EstadoRainhas();
        System.out.println("Estado inicial:" + inicial + "\n");
        Nodo n = null;
        n = new SubidaMontanha(new MostraStatusConsole()).busca(inicial);
        System.out.println("solu\u00e7\u00e3o:\n" + n.getEstado() + "\n\n");
    }
}

