/*
 * Decompiled with CFR 0.152.
 */
package util;

import busca.AEstrela;
import busca.Aleatorio;
import busca.Antecessor;
import busca.Busca;
import busca.BuscaBidirecional;
import busca.BuscaIterativo;
import busca.BuscaLargura;
import busca.BuscaProfundidade;
import busca.Estado;
import busca.Heuristica;
import busca.MostraStatusConsole;
import busca.Nodo;
import busca.SubidaMontanha;
import exemplos.Estado8Puzzle;
import exemplos.EstadoJarros;
import exemplos.EstadoMapa;
import exemplos.EstadoRainhas;
import exemplos.HLAC;
import exemplos.MissionarioCanibal;
import exemplos.QuadradoMagico;
import exemplos.QuadradoMagicoB;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class AppletDemoBusca
extends JApplet {
    boolean isStandalone = false;
    JTextArea text = new JTextArea();
    JComboBox cAlgoritmo;
    JComboBox cProblema;
    JButton para;
    JButton executa;
    JTextField visitados = new JTextField(30);
    JTextField tPars = new JTextField(10);
    JCheckBox comFechados;
    JCheckBox comPoda;
    Problema problema = null;
    Busca algBusca = null;

    public void init() {
        try {
            this.getContentPane().setLayout(new BorderLayout());
            this.executa = new JButton("Executa");
            this.executa.setEnabled(false);
            this.executa.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    AppletDemoBusca.this.executa();
                }
            });
            this.para = new JButton("P\u00b7ra");
            this.para.setEnabled(false);
            this.para.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    if (AppletDemoBusca.this.algBusca != null) {
                        AppletDemoBusca.this.algBusca.para();
                    }
                }
            });
            this.cAlgoritmo = new JComboBox();
            this.cProblema = new JComboBox();
            this.cProblema.addItem("<sem sele\u00c1\u201eo>");
            this.cProblema.addItem(new Jarros());
            this.cProblema.addItem(new P_HLAC());
            this.cProblema.addItem(new P_MisCa());
            this.cProblema.addItem(new P_Mapa());
            this.cProblema.addItem(new P_Puzzle1());
            this.cProblema.addItem(new P_Puzzle2());
            this.cProblema.addItem(new P_Puzzle3());
            this.cProblema.addItem(new P_Rainhas());
            this.cProblema.addItem(new P_Quadrado1());
            this.cProblema.addItem(new P_Quadrado2());
            this.cProblema.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    AppletDemoBusca.this.executa.setEnabled(false);
                    AppletDemoBusca.this.tPars.setEditable(false);
                    AppletDemoBusca.this.tPars.setText("");
                    AppletDemoBusca.this.tPars.setToolTipText("sem par\u201ametros para este problema");
                    int sel = AppletDemoBusca.this.cProblema.getSelectedIndex();
                    if (sel > 0) {
                        Object a2;
                        AppletDemoBusca.this.problema = (Problema)AppletDemoBusca.this.cProblema.getSelectedItem();
                        if (AppletDemoBusca.this.problema.getToolTip() != null) {
                            AppletDemoBusca.this.tPars.setEditable(true);
                            AppletDemoBusca.this.tPars.setToolTipText(AppletDemoBusca.this.problema.getToolTip());
                        }
                        Estado inicial = AppletDemoBusca.this.problema.getInicial();
                        Estado meta = AppletDemoBusca.this.problema.getMeta();
                        AppletDemoBusca.this.text.setText(inicial.getDescricao());
                        AppletDemoBusca.this.text.append("\nEstado inicial=" + inicial);
                        if (meta != null) {
                            AppletDemoBusca.this.text.append("\nEstado meta=" + EstadoMapa.nomes[EstadoMapa.getMeta()]);
                        }
                        AppletDemoBusca.this.executa.setEnabled(true);
                        AppletDemoBusca.this.cAlgoritmo.removeAllItems();
                        AppletDemoBusca.this.cAlgoritmo.addItem(new BuscaLargura());
                        AppletDemoBusca.this.cAlgoritmo.addItem(new BuscaProfundidade());
                        AppletDemoBusca.this.cAlgoritmo.addItem(new BuscaIterativo());
                        try {
                            Heuristica h = (Heuristica)((Object)inicial);
                            AppletDemoBusca.this.cAlgoritmo.addItem(new AEstrela());
                        }
                        catch (Exception h) {
                            // empty catch block
                        }
                        try {
                            a2 = (Aleatorio)((Object)inicial);
                            AppletDemoBusca.this.cAlgoritmo.addItem(new SubidaMontanha());
                        }
                        catch (Exception a2) {
                            // empty catch block
                        }
                        try {
                            a2 = (Antecessor)((Object)inicial);
                            AppletDemoBusca.this.cAlgoritmo.addItem(new BuscaBidirecional());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            JPanel panelN = new JPanel();
            panelN.setLayout(new GridLayout(0, 1));
            this.tPars.setEditable(false);
            this.tPars.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    try {
                        AppletDemoBusca.this.problema.setParametros(AppletDemoBusca.this.tPars.getText());
                    }
                    catch (Exception e) {
                        AppletDemoBusca.this.text.append("Erro: " + e);
                    }
                }
            });
            JPanel p = new JPanel();
            p.setLayout(new FlowLayout(0));
            p.add(new JLabel("Problema:"));
            p.add(this.cProblema);
            p.add(new JLabel("   Par\u201ametros:"));
            p.add(this.tPars);
            panelN.add(p);
            p = new JPanel();
            p.setLayout(new FlowLayout(0));
            p.add(new JLabel("Algoritmo:"));
            p.add(this.cAlgoritmo);
            p.add(this.executa);
            p.add(this.para);
            panelN.add(p);
            this.comFechados = new JCheckBox("usar 'fechados'", true);
            this.comFechados.setToolTipText("Se ativado, um nodo n\u201eo gera sucessor igual a um outro da lista de fechados (j\u00b7 visitados), sen\u201eo considera s\u00db a ascendencia direta do nodo.");
            this.comPoda = new JCheckBox("podar", true);
            this.comPoda.setToolTipText("Se ativado, um nodo n\u201eo gera sucessor igual a um outro j\u00b7 criado.");
            this.comPoda.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        AppletDemoBusca.this.comFechados.setSelected(false);
                    }
                }
            });
            p = new JPanel();
            p.setLayout(new FlowLayout(0));
            p.add(new JLabel("Nodos visitados:"));
            p.add(this.visitados);
            p.add(this.comPoda);
            p.add(this.comFechados);
            this.visitados.setEditable(false);
            this.getContentPane().add((Component)panelN, "North");
            this.getContentPane().add((Component)new JScrollPane(this.text), "Center");
            this.getContentPane().add((Component)p, "South");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void executa() {
        this.para.setEnabled(true);
        this.executa.setEnabled(false);
        final Estado inicial = this.problema.getInicial();
        final Estado meta = this.problema.getMeta();
        this.visitados.setText("");
        this.text.setText(this.algBusca + "\n");
        this.text.append("Estado inicial=" + inicial);
        if (meta != null) {
            this.text.append("Estado meta=" + meta);
        }
        try {
            this.algBusca = (Busca)this.cAlgoritmo.getSelectedItem();
        }
        catch (Exception e) {
            System.err.println("N\u201eo foi selecionado um algoritmo");
            return;
        }
        this.algBusca.setPodar(this.comPoda.isSelected());
        this.algBusca.usarFechados(this.comFechados.isSelected());
        try {
            BuscaProfundidade bp = (BuscaProfundidade)this.algBusca;
            bp.setProfMax(this.problema.getProfundidade());
        }
        catch (Exception bp) {
            // empty catch block
        }
        this.algBusca.setMostra(new MostraStatusConsole(){

            protected void mostraFim() {
                AppletDemoBusca.this.visitados.setText(String.valueOf(this.getStatus().getVisitados()) + " em " + this.getStatus().getTempoDecorrido() + " ms, profundidade=" + this.getStatus().getProfundidade());
            }

            protected void mostra() {
                this.mostraFim();
            }

            protected void println(String s) {
                AppletDemoBusca.this.text.append(String.valueOf(s) + "\n");
            }
        });
        Thread busca = new Thread(){

            public void run() {
                block8: {
                    try {
                        try {
                            Nodo n = null;
                            AppletDemoBusca.this.algBusca.setParar(false);
                            AppletDemoBusca.this.algBusca.novoStatus();
                            try {
                                BuscaBidirecional bbd = (BuscaBidirecional)AppletDemoBusca.this.algBusca;
                                n = bbd.busca(inicial, meta);
                            }
                            catch (Exception e) {
                                n = AppletDemoBusca.this.algBusca.busca(inicial);
                            }
                            if (n != null) {
                                AppletDemoBusca.this.text.append("\n\nsolu\u00c1\u201eo (" + n.getProfundidade() + " opera\u00c1\u0131es, custo=" + n.g() + "):\n" + n.montaCaminho() + "\n\n");
                                break block8;
                            }
                            AppletDemoBusca.this.text.append("\n\nsem solu\u00c1\u201eo!");
                        }
                        catch (Throwable e) {
                            AppletDemoBusca.this.text.append("Erro: " + e);
                        }
                    }
                    finally {
                        AppletDemoBusca.this.para.setEnabled(false);
                        AppletDemoBusca.this.executa.setEnabled(true);
                        AppletDemoBusca.this.text.setCaretPosition(AppletDemoBusca.this.text.getText().length());
                        AppletDemoBusca.this.algBusca.para();
                    }
                }
            }
        };
        busca.start();
    }

    public static void main(String[] args) {
        AppletDemoBusca applet = new AppletDemoBusca();
        applet.isStandalone = true;
        Frame frame = new Frame(){

            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    System.exit(0);
                }
            }

            public synchronized void setTitle(String title) {
                super.setTitle(title);
                this.enableEvents(64L);
            }
        };
        frame.setTitle("Demonstra\u00c1\u201eo de algoritmos de busca");
        frame.add((Component)applet, "Center");
        applet.init();
        applet.start();
        frame.setSize(700, 500);
        Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((d.width - frame.getSize().width) / 2, (d.height - frame.getSize().height) / 2);
        frame.setVisible(true);
    }

    abstract class Problema {
        String id;

        Problema(String s) {
            this.id = s;
        }

        public String toString() {
            return this.id;
        }

        abstract Estado getInicial();

        Estado getMeta() {
            return null;
        }

        int getProfundidade() {
            return 20;
        }

        String getToolTip() {
            return null;
        }

        void setParametros(String p) {
        }
    }

    class Jarros
    extends Problema {
        Jarros() {
            super("Jarros");
        }

        Estado getInicial() {
            return new EstadoJarros(0, 0, "inicial");
        }

        Estado getMeta() {
            return new EstadoJarros(2, 2, "meta");
        }
    }

    class P_HLAC
    extends Problema {
        P_HLAC() {
            super("Homem, Lobo, Carneiro e o Alface");
        }

        Estado getInicial() {
            return new HLAC('e', 'e', 'e', 'e', "inicial");
        }

        Estado getMeta() {
            return new HLAC('d', 'd', 'd', 'd', "meta");
        }
    }

    class P_MisCa
    extends Problema {
        P_MisCa() {
            super("Missionarios e Canibais");
        }

        Estado getInicial() {
            return new MissionarioCanibal(3, 3, 'e', "inicial");
        }

        Estado getMeta() {
            return new MissionarioCanibal(0, 0, 'd', "meta");
        }
    }

    class P_Mapa
    extends Problema {
        int inicial;

        P_Mapa() {
            super("Caminho em mapa");
            this.inicial = 8;
            EstadoMapa.setMeta(15);
        }

        Estado getInicial() {
            return new EstadoMapa(this.inicial);
        }

        Estado getMeta() {
            return new EstadoMapa(EstadoMapa.getMeta());
        }

        String getToolTip() {
            return "Informe a cidade inicial";
        }

        void setParametros(String p) {
            int i = 0;
            while (i < EstadoMapa.nomes.length) {
                if (EstadoMapa.nomes[i] == AppletDemoBusca.this.tPars.getText().charAt(0)) {
                    this.inicial = i;
                    break;
                }
                ++i;
            }
            AppletDemoBusca.this.text.append("\nNovo estado inicial=" + this.getInicial());
        }
    }

    class P_Puzzle1
    extends Problema {
        P_Puzzle1() {
            super("8-Puzzle (estado inicial aleat\u00dbrio)");
        }

        Estado getInicial() {
            return new Estado8Puzzle();
        }

        Estado getMeta() {
            return Estado8Puzzle.getEstadoMeta();
        }

        int getProfundidade() {
            return 30;
        }
    }

    class P_Puzzle2
    extends Problema {
        P_Puzzle2() {
            super("8-Puzzle (estado inicial f\u00b7cil)");
        }

        Estado getInicial() {
            return Estado8Puzzle.getEstadoFacil();
        }

        Estado getMeta() {
            return Estado8Puzzle.getEstadoMeta();
        }
    }

    class P_Puzzle3
    extends Problema {
        P_Puzzle3() {
            super("8-Puzzle (estado inicial dif\u00cccil)");
        }

        Estado getInicial() {
            return Estado8Puzzle.getEstadoDificil();
        }

        Estado getMeta() {
            return Estado8Puzzle.getEstadoMeta();
        }

        int getProfundidade() {
            return 80;
        }
    }

    class P_Rainhas
    extends Problema {
        P_Rainhas() {
            super("8 Rainhas");
        }

        Estado getInicial() {
            return new EstadoRainhas();
        }

        String getToolTip() {
            return "Informe o n\u02d9mero de rainhas";
        }

        void setParametros(String p) {
            EstadoRainhas.setTamanho(Integer.parseInt(p));
        }
    }

    class P_Quadrado1
    extends Problema {
        P_Quadrado1() {
            super("Quadrado m\u00b7gico (vers\u201eo a)");
        }

        Estado getInicial() {
            return new QuadradoMagico();
        }

        String getToolTip() {
            return "Informe a dimens\u201eo do quadrado";
        }

        void setParametros(String p) {
            QuadradoMagico.setTamanho(Integer.parseInt(p));
        }
    }

    class P_Quadrado2
    extends Problema {
        P_Quadrado2() {
            super("Quadrado m\u00b7gico (vers\u201eo b)");
        }

        Estado getInicial() {
            return new QuadradoMagicoB();
        }

        String getToolTip() {
            return "Informe a dimens\u201eo do quadrado";
        }

        void setParametros(String p) {
            QuadradoMagico.setTamanho(Integer.parseInt(p));
        }
    }
}

