/*
 * Decompiled with CFR 0.152.
 */
package exemplos;

import busca.BuscaIterativo;
import busca.BuscaLargura;
import busca.BuscaProfundidade;
import busca.Estado;
import busca.Nodo;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EstadoJarros
implements Estado {
    int j4 = 0;
    int j3 = 0;
    String op = "";

    public EstadoJarros(int a, int s, String o) {
        this.j4 = a;
        this.j3 = s;
        this.op = o;
    }

    @Override
    public String getDescricao() {
        return "Neste problema existem dois jarros, um com capacidade\npara 4 litros e outro com capacidade para 3 litros.\nPode-se encher os jarros, esvazi\u00e1-los ou derramar a \u00e1gua\nde um deles no outro.\nO objetivo \u00e9 deixar o jarro de 3l com 2l de \u00e1gua.\n";
    }

    @Override
    public boolean ehMeta() {
        return this.j4 == 0 && this.j3 == 2;
    }

    public boolean equals(Object o) {
        try {
            EstadoJarros e = (EstadoJarros)o;
            if (e.j4 == this.j4 && e.j3 == this.j3) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public int hashCode() {
        return (this.j4 + "," + this.j3).hashCode();
    }

    @Override
    public List<Estado> sucessores() {
        LinkedList<Estado> suc = new LinkedList<Estado>();
        if (this.j4 < 4) {
            suc.add(new EstadoJarros(4, this.j3, "encher(4)"));
        }
        if (this.j3 < 3) {
            suc.add(new EstadoJarros(this.j4, 3, "encher(3)"));
        }
        if (this.j4 > 0) {
            suc.add(new EstadoJarros(0, this.j3, "esvaziar(4)"));
        }
        if (this.j3 > 0) {
            suc.add(new EstadoJarros(this.j4, 0, "esvaziar(3)"));
        }
        int folgaJ3 = 3 - this.j3;
        if (this.j4 > 0 && folgaJ3 > 0) {
            int qdtDerramada = Math.min(folgaJ3, this.j4);
            int ficaJ4 = this.j4 - qdtDerramada;
            int ficaJ3 = this.j3 + qdtDerramada;
            if (ficaJ4 < 0) {
                ficaJ4 = 0;
            }
            suc.add(new EstadoJarros(ficaJ4, ficaJ3, "jogar(4,3)"));
        }
        int folgaJ4 = 4 - this.j4;
        if (this.j3 > 0 && folgaJ4 > 0) {
            int qdtDerramada = Math.min(folgaJ4, this.j3);
            int ficaJ4 = this.j4 + qdtDerramada;
            int ficaJ3 = this.j3 - qdtDerramada;
            if (ficaJ3 < 0) {
                ficaJ4 = 0;
            }
            suc.add(new EstadoJarros(ficaJ4, ficaJ3, "jogar(3,4)"));
        }
        return suc;
    }

    public String toString() {
        return "\n(" + this.j4 + "," + this.j3 + ") - " + this.op;
    }

    @Override
    public int custo() {
        return 1;
    }

    public static void main(String[] a) {
        EstadoJarros inicial = new EstadoJarros(0, 0, "inicial");
        System.out.println("busca em largura");
        Nodo n = new BuscaLargura().busca(inicial);
        if (n == null) {
            System.out.println("sem solu\u00e7\u00e3o!");
        } else {
            System.out.println("solu\u00e7\u00e3o:\n" + n.montaCaminho() + "\n\n");
        }
        System.out.println("busca em profundidade");
        n = new BuscaProfundidade(15).busca(inicial);
        if (n == null) {
            System.out.println("sem solu\u00e7\u00e3o!");
        } else {
            System.out.println("solu\u00e7\u00e3o:\n" + n.montaCaminho() + "\n\n");
        }
        System.out.println("busca em profundidade iterativo");
        n = new BuscaIterativo().busca(inicial);
        if (n == null) {
            System.out.println("sem solu\u00e7\u00e3o!");
        } else {
            System.out.println("solu\u00e7\u00e3o:\n" + n.montaCaminho() + "\n\n");
        }
    }
}

