/*
 * Decompiled with CFR 0.152.
 */
package exemplos;

import busca.Estado;
import busca.Heuristica;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadradoMagico
implements Estado,
Heuristica {
    static short tam = (short)4;
    static int nroMagico = 34;
    static long nroTestes = 0L;
    static long totalFolhas = QuadradoMagico.fat(tam * tam) / 1000L / 1000L;
    int[][] tabuleiro = new int[tam][tam];
    int meuNro = 0;
    int h = -1;

    @Override
    public String getDescricao() {
        return "Um quadrado m\u00e1gico de ordem n \u00e9 um arranjo quadrado de n\u00b2 inteiros\ndistintos dispostos de tal maneira que os n\u00fameros de uma linha\nqualquer, de uma coluna qualquer ou da diagonal principal t\u00eam mesma\nsoma, chamada constante m\u00e1gica do quadrado. O quadrado \u00e9 normal se os\nn\u00b2 n\u00fameros que o formam s\u00e3o os primeiros n\u00b2 inteiros positivos.\n\nA constante m\u00e1gica do quadrado \u00e9 dada por: n (n\u00b2 + 1) / 2\nNeste exemplo, n = 4 e a constante m\u00e1gica=34\n\nNesta vers\u00e3o (a), o tabuleira inicia vazio e, \na cada n\u00edvel, um novo n\u00famero e adicionado.\n(tem heur\u00edstica implementada)\n";
    }

    public static void setTamanho(int t) {
        tam = (short)t;
        nroMagico = t * (t * t + 1) / 2;
    }

    static long fat(int n) {
        if (n == 0) {
            return 1L;
        }
        return (long)n * QuadradoMagico.fat(n - 1);
    }

    public QuadradoMagico() {
        for (int l = 0; l < tam; ++l) {
            for (int c = 0; c < tam; ++c) {
                this.tabuleiro[l][c] = 0;
            }
        }
    }

    QuadradoMagico(QuadradoMagico modelo) {
        for (int l = 0; l < tam; ++l) {
            for (int c = 0; c < tam; ++c) {
                this.tabuleiro[l][c] = modelo.tabuleiro[l][c];
            }
        }
        this.meuNro = modelo.meuNro;
    }

    public boolean equals(Object o) {
        try {
            QuadradoMagico e = (QuadradoMagico)o;
            for (int l = 0; l < tam; ++l) {
                for (int c = 0; c < tam; ++c) {
                    if (this.tabuleiro[l][c] == e.tabuleiro[l][c]) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean ehMeta() {
        int l;
        int s;
        if (this.meuNro < tam * tam) {
            return false;
        }
        if (++nroTestes % 100000L == 0L) {
            System.out.print("J\u00e1 foram testadas " + (float)nroTestes / 1000.0f / 1000.0f + " milh\u00f5es de folhas (total=" + totalFolhas + " milh\u00f5es)\n");
            System.out.print("Exemplo:" + this + "\n");
        }
        int s1linha = -1;
        for (int l2 = 0; l2 < tam; ++l2) {
            s = 0;
            for (int c = 0; c < tam; ++c) {
                s += this.tabuleiro[l2][c];
            }
            if (s1linha == -1) {
                s1linha = s;
                continue;
            }
            if (s1linha == s) continue;
            return false;
        }
        for (int c = 0; c < tam; ++c) {
            s = 0;
            for (l = 0; l < tam; ++l) {
                s += this.tabuleiro[l][c];
            }
            if (s1linha == s) continue;
            return false;
        }
        int dp = 0;
        for (int l3 = 0; l3 < tam; ++l3) {
            dp += this.tabuleiro[l3][l3];
        }
        if (dp != s1linha) {
            return false;
        }
        int ds = 0;
        for (l = 0; l < tam; ++l) {
            ds += this.tabuleiro[tam - 1 - l][l];
        }
        return ds == s1linha;
    }

    @Override
    public List<Estado> sucessores() {
        LinkedList<Estado> suc = new LinkedList<Estado>();
        int seguinte = this.meuNro + 1;
        for (int l = 0; l < tam; ++l) {
            for (int c = 0; c < tam; ++c) {
                if (this.tabuleiro[l][c] != 0) continue;
                QuadradoMagico novo = new QuadradoMagico(this);
                novo.tabuleiro[l][c] = seguinte;
                novo.meuNro = seguinte;
                if (novo.poda()) continue;
                suc.add(novo);
            }
        }
        return suc;
    }

    protected boolean poda() {
        int soma;
        for (int l = 0; l < tam; ++l) {
            soma = 0;
            for (int c = 0; c < tam; ++c) {
                if (this.tabuleiro[l][c] != 0) {
                    soma += this.tabuleiro[l][c];
                    continue;
                }
                soma = 0;
                break;
            }
            if (soma == 0 || soma == nroMagico) continue;
            return true;
        }
        for (int c = 0; c < tam; ++c) {
            soma = 0;
            for (int l = 0; l < tam; ++l) {
                if (this.tabuleiro[l][c] != 0) {
                    soma += this.tabuleiro[l][c];
                    continue;
                }
                soma = 0;
                break;
            }
            if (soma == 0 || soma == nroMagico) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer r = new StringBuffer("\n");
        for (int i = 0; i < tam; ++i) {
            for (int j = 0; j < tam; ++j) {
                r.append(this.tabuleiro[i][j]);
                if (j + 1 >= tam) continue;
                r.append(" ");
            }
            if (i + 1 < tam) {
                r.append("\n");
                continue;
            }
            r.append("  h()=" + this.h() + "\n");
        }
        return r.toString();
    }

    @Override
    public int custo() {
        return 1;
    }

    @Override
    public int h() {
        if (this.h >= 0) {
            return this.h;
        }
        int[] linhas = new int[tam];
        int[] cols = new int[tam];
        for (int i = 0; i < tam; ++i) {
            linhas[i] = 0;
            cols[i] = 0;
        }
        int soma = 0;
        for (int l = 0; l < tam; ++l) {
            for (int c = 0; c < tam; ++c) {
                int n = l;
                linhas[n] = linhas[n] + this.tabuleiro[l][c];
                int n2 = c;
                cols[n2] = cols[n2] + this.tabuleiro[l][c];
                soma += this.tabuleiro[l][c];
            }
        }
        int dp = 0;
        for (int l = 0; l < tam; ++l) {
            dp += this.tabuleiro[l][l];
        }
        int ds = 0;
        for (int l = 0; l < tam; ++l) {
            ds += this.tabuleiro[tam - 1 - l][l];
        }
        int m\u00e9dia = nroMagico;
        int desvio = 0;
        for (int i = 0; i < tam; ++i) {
            desvio += Math.abs(linhas[i] - m\u00e9dia);
            desvio += Math.abs(cols[i] - m\u00e9dia);
        }
        desvio += Math.abs(dp - m\u00e9dia);
        this.h = desvio += Math.abs(ds - m\u00e9dia);
        return desvio;
    }
}

