package miner;

import jmadem.*;
import jason.asSyntax.*;
import jason.asSemantics.*;
import java.lang.Math.*;
import java.util.*;

/** 
 *
 * @author Francisco Grimaldo
 */
public class GoldDistance implements UtilityFunctionInt 
{
	/**
	  * Returns the name of the utility function
	  *
	  * @return	"goldDistance"
	  */
    public String getId()
	{
		return "goldDistance";
	}
	
	/**
	  * Returns the agent's preference to pick up a gold. 
	  *
	  * @param	auctioneer	agent asking for preference
	  * @param	alloc	allocation being evaluated
  	  * @param	agArch	architecture of the MADeM agent
	  * 
	  * @throws	UtilityFunctionException when any error occurs
	  * @return	MAX - distance from agent to gold 
	  */
    public float computeUtility(String auctioneer, Allocation a, MADeMAgArch agArch) throws UtilityFunctionException
	{
		Term [] termArray;
		Unifier un = new Unifier();
		Literal l, pos;
		
		// Allocation of the form: gold(X,Y,ag)
		Literal alloc = (Literal)a.getTerm();
		termArray = alloc.getTermsArray();
		String ag = termArray[2].toString();
		
		// Do not vote for others
 		if(!ag.equals( agArch.getAgName())) 
			return 0;
		
		l = Literal.parseLiteral("free");
		pos = agArch.getTS().getAg().findBel(l, un);
		if(pos == null) {
			// Agent is not free
			return 0;
		}
		l = Literal.parseLiteral("carrying_gold");
		pos = agArch.getTS().getAg().findBel(l, un);
		if(pos != null) {
			// Agent is carrying_gold
			return 0;
		}

		String sx = termArray[0].toString();
 		String sy = termArray[1].toString();
		l = Literal.parseLiteral("allocated(gold("+sx+","+sy+",_))");
		pos = agArch.getTS().getAg().findBel(l, un);
		if(pos != null) {
			// Gold already allocated
			return 0;
		}
		
		// Calculate distance
		Integer x = Integer.parseInt(termArray[0].toString());
 		Integer y = Integer.parseInt(termArray[1].toString());
		l = Literal.parseLiteral("pos(_,_)");
		pos = agArch.getTS().getAg().findBel(l, un);
		if (pos == null) {
			// Agent does not know its position
			return 0;
		}
		termArray = pos.getTermsArray();
		Integer ax = Integer.parseInt(termArray[0].toString());
 		Integer ay = Integer.parseInt(termArray[1].toString());
		
		// Return preference
		return 1000 - (Math.abs(x-ax)+ Math.abs(y-ay) );
	}
}

