package boss;

import jmadem.*;
import jason.asSyntax.*;
import jason.asSemantics.*;
import java.lang.Math.*;
import java.util.*;

/** 
 *
 * @author Francisco Grimaldo
 */
public class DistanceTo implements UtilityFunctionInt 
{
	/**
	  * Returns the name of the utility function
	  *
	  * @return	"distanceTo"
	  */
    public String getId()
	{
		return "distanceTo";
	}
	
	/**
	  * Returns the boss' preference to be the leader of a miner. 
	  *
	  * @param	auctioneer	agent asking for preference
	  * @param	alloc	allocation being evaluated
  	  * @param	agArch	architecture of the MADeM agent
	  * 
	  * @throws	UtilityFunctionException when any error occurs
	  * @return	MAX - distance of agent to the boss 
	  */
    public float computeUtility(String auctioneer, Allocation a, MADeMAgArch agArch) throws UtilityFunctionException
	{
		Term [] termArray;
		Unifier un = new Unifier();
		Literal l, pos;
		
		// Allocation of the form: leader(X,Y,ag)
		Literal alloc = (Literal)a.getTerm();
		termArray = alloc.getTermsArray();
		String ag = termArray[2].toString();

		// No preference if you are not proposed to be the boss
 		if(!ag.equals( agArch.getAgName())) 
			return 0;

		// Preference is (1000 -) the distance miner-boss
		Integer x = Integer.parseInt(termArray[0].toString());
 		Integer y = Integer.parseInt(termArray[1].toString());
		l = Literal.parseLiteral("pos(_,_)");
		pos = agArch.getTS().getAg().findBel(l, un);
		if (pos == null) {
			// Boss does not know its position
			return 0;
		}
		termArray = pos.getTermsArray();
		Integer ax = Integer.parseInt(termArray[0].toString());
 		Integer ay = Integer.parseInt(termArray[1].toString());
 		
 	    // Return preference
		return 1000 - (Math.abs(x-ax)+ Math.abs(y-ay) );
	}
}

