package boss;

import jmadem.*;
import jason.asSyntax.*;
import jason.asSemantics.*;
import java.lang.Math.*;
import java.util.*;

/** 
 *
 * @author Francisco Grimaldo
 */
public class FreeWorkers implements UtilityFunctionInt 
{
	/**
	  * Returns the name of the utility function
	  *
	  * @return	"freeWorkers"
	  */
    public String getId()
	{
		return "freeWorkers";
	}
	
	/**
	  * Returns the boss' preference to lend a miner from its group. 
	  *
	  * @param	auctioneer	agent asking for preference
	  * @param	alloc	allocation being evaluated
	  * @param	agArch	architecture of the MADeM agent
	  * 
	  * @throws	UtilityFunctionException when any error occurs
	  * @return	number of leadered workers that are free 
	  */
    public float computeUtility(String auctioneer, Allocation a, MADeMAgArch agArch) throws UtilityFunctionException
	{
		Term [] termArray;
		Unifier un = new Unifier();
		Literal l, pos;
		
		// Allocation of the form: get_miner_from(X,Y,ag)
		Literal alloc = (Literal)a.getTerm();
		termArray = alloc.getTermsArray();
		String ag = termArray[2].toString();

		// No preference if you are not proposed to lend the miner
 		if(!ag.equals( agArch.getAgName())) 
			return 0;

		// Preference is the number of workers free
		int nbWorkers = 0;
		l = Literal.parseLiteral("free(_)");
		Iterator<Literal> it = agArch.getTS().getAg().getBB().getRelevant(l);
		if (it != null)
			while (it.hasNext())
			{
				it.next();
				nbWorkers++;
			}
		return nbWorkers;
	}
}

