package fran;

import jmadem.*;
import jason.mas2j.ClassParameters;
import jason.runtime.Settings;
import jason.JasonException;

import java.util.logging.Level;
import java.util.logging.Logger;


/**
  * Basic architecture for a Test Agent performing MADeM decisions.
  *
  * @author Francisco Grimaldo
  */
public class FranAgentArch extends MADeMAgArch 
{
	/** Class logger */
	private Logger logger = Logger.getLogger(FranAgentArch.class.getName());

	/**
	  * Test agent initiator. Register several test utility functions 
	  *
	  * @param	agClass	agent class definition
	  * @param	bbPars	agent class parameters
	  * @param	asSrc	AgentSpeak source code
	  * @param	stts	MAS Runtime Settings for an Agent
	  * @throws	JasonException
	  */
    @Override
	public void initAg(String agClass, ClassParameters bbPars, String asSrc, Settings stts) throws JasonException 
	{
        super.initAg(agClass, bbPars, asSrc, stts);
        logger = Logger.getLogger(FranAgentArch.class.getName() + "." + getAgName());

		// Register several test utility functions
		addUtilityFunction("fran.MaximumUtilityFunction");
		addUtilityFunction("fran.MinimumUtilityFunction");
    }
}
