package miguel;

import jmadem.*;
import jason.asSyntax.*;

/** 
 * Test utility function always returning the utility value 0.9 if the allocation affects the agent.
 * Otherwhise, it returns 0.
 *
 * @author Francisco Grimaldo
 */
public class MaximumUtilityFunction implements UtilityFunctionInt 
{
	/**
	  * Returns the name of the utility function
	  *
	  * @return	"maximumUtilityFunction"
	  */
    public String getId()
	{
		return "maximumUtilityFunction";
	}
	
	/**
	  * Returns the highest normalized utility value for any allocation. 
	  *
	  * @param	auctioneer	agent asking for preference
	  * @param	alloc	allocation being evaluated
	  * 
	  * @throws	utilityFunctionException when any error occurs
	  * @return	always 1, which will be the preference assigned to any allocation 
	  */
    public float computeUtility(String auctioneer, Allocation a, MADeMAgArch agArch) throws UtilityFunctionException
	{
		Literal alloc = (Literal)a.getTerm();
		Term []termArray = alloc.getTermsArray();
		String ag = termArray[1].toString();
 		if( !ag.equals(agArch.getAgName()) ) 
			return 0;
		else
			return (float) 0.9;
	}
}

